/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.events;

public enum EventType {
    INSERT(1),
    DELETE(2),
    UPDATE(3),
    DDL(5),
    START(6),
    COMMIT(7),
    SELECT_LOB_LOCATOR(9),
    LOB_WRITE(10),
    LOB_TRIM(11),
    LOB_ERASE(29),
    MISSING_SCN(34),
    ROLLBACK(36),
    XML_BEGIN(68),
    XML_WRITE(70),
    XML_END(71),
    EXTENDED_STRING_BEGIN(91),
    EXTENDED_STRING_WRITE(92),
    EXTENDED_STRING_END(93),
    UNSUPPORTED(255);

    private static EventType[] types;
    private int value;

    private EventType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static EventType from(int value) {
        return value < types.length ? types[value] : UNSUPPORTED;
    }

    static {
        types = new EventType[256];
        EventType[] eventTypeArray = EventType.values();
        int n = eventTypeArray.length;
        for (int i = 0; i < n; ++i) {
            EventType option;
            EventType.types[option.getValue()] = option = eventTypeArray[i];
        }
    }
}

