/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.parser;

import io.debezium.connector.oracle.logminer.parser.AbstractSingleColumnSqlRedoPreambleParser;
import io.debezium.connector.oracle.logminer.parser.ParserUtils;
import io.debezium.relational.Table;

public abstract class AbstractSelectSingleColumnSqlRedoPreambleParser
extends AbstractSingleColumnSqlRedoPreambleParser {
    private static final String SELECT = "select";
    private static final String INTO = "into";
    private static final String FROM = "from";
    private static final String WHERE = "where";
    private final String preamble;

    public AbstractSelectSingleColumnSqlRedoPreambleParser(String preamble) {
        this.preamble = preamble;
    }

    @Override
    protected void parseInternal(String sql, Table table) {
        int startIndex = sql.indexOf(this.preamble);
        if (startIndex == -1) {
            throw new IllegalStateException("Failed to locate preamble: " + this.preamble);
        }
        startIndex = sql.indexOf(" ", startIndex + this.preamble.length() + 1);
        if ((startIndex = sql.indexOf(SELECT, startIndex)) == -1) {
            throw new IllegalStateException("Failed to locate SELECT keyword");
        }
        startIndex = sql.indexOf(" ", startIndex) + 1;
        startIndex = this.parseSelectable(sql, startIndex, table);
        if (AbstractSelectSingleColumnSqlRedoPreambleParser.startsWithAtIndex(INTO, startIndex = sql.indexOf(" ", startIndex) + 1, sql)) {
            startIndex += INTO.length() + 1;
            startIndex = this.parseIntoClause(sql, startIndex);
        }
        if (AbstractSelectSingleColumnSqlRedoPreambleParser.startsWithAtIndex(FROM, startIndex, sql)) {
            startIndex += FROM.length() + 1;
            startIndex = this.parseFromClause(sql, startIndex);
        }
        if (AbstractSelectSingleColumnSqlRedoPreambleParser.startsWithAtIndex(WHERE, startIndex, sql)) {
            startIndex += WHERE.length() + 1;
            startIndex = this.parseWhereClause(sql, startIndex, table);
        }
        ParserUtils.setColumnUnavailableValues(this.columnValues, table);
    }

    protected int parseSelectable(String sql, int index, Table table) {
        return AbstractSelectSingleColumnSqlRedoPreambleParser.parseQuotedValue(sql, index, value -> {
            if (table.columnWithName(value) == null) {
                throw new IllegalStateException("No column named " + value + " found in table " + String.valueOf(table.id()));
            }
            this.columnName = value;
        });
    }

    protected int parseIntoClause(String sql, int index) {
        return index;
    }

    protected int parseFromClause(String sql, int index) {
        if (sql.charAt(index = AbstractSelectSingleColumnSqlRedoPreambleParser.parseQuotedValue(sql, index, value -> {
            this.schemaName = value;
        })) != '.') {
            throw new IllegalStateException("Expected object with format \"<schema>\".\"<table>\"");
        }
        ++index;
        index = AbstractSelectSingleColumnSqlRedoPreambleParser.parseQuotedValue(sql, index, value -> {
            this.tableName = value;
        });
        return ++index;
    }
}

