/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.DebeziumException;
import io.debezium.bean.StandardBeanNames;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.base.DefaultQueueProvider;
import io.debezium.connector.base.QueueProvider;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.common.DebeziumHeaderProducer;
import io.debezium.connector.oracle.AbstractOracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.Module;
import io.debezium.connector.oracle.OracleChangeEventSourceFactory;
import io.debezium.connector.oracle.OracleChangeEventSourceMetricsFactory;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectionFactory;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleDefaultValueConverter;
import io.debezium.connector.oracle.OracleErrorHandler;
import io.debezium.connector.oracle.OracleEventMetadataProvider;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.StreamingAdapter;
import io.debezium.document.DocumentReader;
import io.debezium.heartbeat.HeartbeatFactory;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.signal.SignalProcessor;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.CustomConverterRegistry;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnectorTask
extends BaseSourceTask<OraclePartition, OracleOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleConnectorTask.class);
    private static final String CONTEXT_NAME = "oracle-connector-task";
    private final ReentrantLock commitLock = new ReentrantLock();
    private volatile OracleTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile OracleConnection jdbcConnection;
    private volatile OracleConnection beanRegistryJdbcConnection;
    private volatile ErrorHandler errorHandler;
    private volatile OracleDatabaseSchema schema;
    private OracleConnectorConfig.ConnectorAdapter connectorAdapter;
    private Partition.Provider<OraclePartition> partitionProvider = null;
    private OffsetContext.Loader<OracleOffsetContext> offsetContextLoader = null;

    public String version() {
        return Module.version();
    }

    public ChangeEventSourceCoordinator<OraclePartition, OracleOffsetContext> start(Configuration config) {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(config);
        this.connectorAdapter = connectorConfig.getConnectorAdapter();
        this.partitionProvider = new OraclePartition.Provider(connectorConfig);
        this.offsetContextLoader = connectorConfig.getAdapter().getOffsetContextLoader();
        TopicNamingStrategy topicNamingStrategy = connectorConfig.getTopicNamingStrategy(CommonConnectorConfig.TOPIC_NAMING_STRATEGY);
        SchemaNameAdjuster schemaNameAdjuster = connectorConfig.schemaNameAdjuster();
        JdbcConfiguration jdbcConfig = connectorConfig.getJdbcConfig();
        OracleConnectionFactory connectionFactory = new OracleConnectionFactory(connectorConfig);
        this.jdbcConnection = connectionFactory.mainConnection();
        boolean extendedStringsSupported = this.jdbcConnection.hasExtendedStringSupport();
        this.registerServiceProviders(connectorConfig.getServiceRegistry());
        OracleValueConverters valueConverters = connectorConfig.getAdapter().getValueConverter(connectorConfig, this.jdbcConnection);
        OracleDefaultValueConverter defaultValueConverter = new OracleDefaultValueConverter(valueConverters, this.jdbcConnection);
        StreamingAdapter.TableNameCaseSensitivity tableNameCaseSensitivity = connectorConfig.getAdapter().getTableNameCaseSensitivity(this.jdbcConnection);
        CustomConverterRegistry customConverterRegistry = (CustomConverterRegistry)connectorConfig.getServiceRegistry().tryGetService(CustomConverterRegistry.class);
        this.schema = new OracleDatabaseSchema(connectorConfig, valueConverters, defaultValueConverter, schemaNameAdjuster, (TopicNamingStrategy<TableId>)topicNamingStrategy, tableNameCaseSensitivity, extendedStringsSupported, customConverterRegistry);
        this.taskContext = new OracleTaskContext(connectorConfig, this.schema);
        Offsets previousOffsets = this.getPreviousOffsets(this.partitionProvider, this.offsetContextLoader);
        this.beanRegistryJdbcConnection = connectionFactory.newConnection();
        if (!Strings.isNullOrEmpty((String)connectorConfig.getPdbName())) {
            this.beanRegistryJdbcConnection.setSessionToPdb(connectorConfig.getPdbName());
        }
        connectorConfig.getBeanRegistry().add(StandardBeanNames.CONFIGURATION, (Object)config);
        connectorConfig.getBeanRegistry().add("ConnectorConfig", (Object)connectorConfig);
        connectorConfig.getBeanRegistry().add("Schema", (Object)this.schema);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.JDBC_CONNECTION, (Object)this.beanRegistryJdbcConnection);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.VALUE_CONVERTER, (Object)valueConverters);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.OFFSETS, (Object)previousOffsets);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.CDC_SOURCE_TASK_CONTEXT, (Object)this.taskContext);
        SnapshotterService snapshotterService = (SnapshotterService)connectorConfig.getServiceRegistry().tryGetService(SnapshotterService.class);
        this.validateRedoLogConfiguration(connectorConfig, snapshotterService);
        connectorConfig.getArchiveDestinationNameResolver().validate(this.jdbcConnection);
        OracleOffsetContext previousOffset = (OracleOffsetContext)previousOffsets.getTheOnlyOffset();
        if (connectorConfig.getGuardrailCollectionsMax() <= 0) {
            LOGGER.info("Guardrail validation skipped");
        } else {
            this.validateGuardrailLimits(connectorConfig, this.jdbcConnection);
        }
        this.validateSchemaHistory((CommonConnectorConfig)connectorConfig, this.jdbcConnection::validateLogPosition, previousOffsets, (DatabaseSchema)this.schema, snapshotterService.getSnapshotter());
        if (previousOffset == null) {
            LOGGER.info("No previous offset found");
        } else {
            LOGGER.info("Found previous offset {}", (Object)previousOffset);
        }
        Clock clock = Clock.system();
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).maxQueueSizeInBytes(connectorConfig.getMaxQueueSizeInBytes()).queueProvider((QueueProvider)new DefaultQueueProvider(connectorConfig.getMaxQueueSize())).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
        this.errorHandler = new OracleErrorHandler(connectorConfig, this.queue, this.errorHandler);
        OracleEventMetadataProvider metadataProvider = new OracleEventMetadataProvider();
        SignalProcessor signalProcessor = new SignalProcessor(OracleConnector.class, (CommonConnectorConfig)connectorConfig, Map.of(), this.getAvailableSignalChannels(), DocumentReader.defaultReader(), previousOffsets);
        EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, topicNamingStrategy, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, (EventMetadataProvider)metadataProvider, new HeartbeatFactory().getScheduledHeartbeat((CommonConnectorConfig)connectorConfig, () -> this.getHeartbeatConnection(connectorConfig, jdbcConfig), exception -> {
            String sqlErrorId = exception.getMessage();
            if (exception.getErrorCode() == 2396) {
                return;
            }
            throw new DebeziumException("Could not execute heartbeat action query (Error: " + sqlErrorId + ")", (Throwable)exception);
        }, this.queue), schemaNameAdjuster, signalProcessor, (DebeziumHeaderProducer)connectorConfig.getServiceRegistry().tryGetService(DebeziumHeaderProducer.class));
        Object streamingMetrics = connectorConfig.getAdapter().getStreamingMetrics(this.taskContext, (ChangeEventQueueMetrics)this.queue, metadataProvider, connectorConfig);
        NotificationService notificationService = new NotificationService(this.getNotificationChannels(), (CommonConnectorConfig)connectorConfig, SchemaFactory.get(), arg_0 -> ((EventDispatcher)dispatcher).enqueueNotification(arg_0));
        ChangeEventSourceCoordinator coordinator = new ChangeEventSourceCoordinator(previousOffsets, this.errorHandler, OracleConnector.class, (CommonConnectorConfig)connectorConfig, (ChangeEventSourceFactory)new OracleChangeEventSourceFactory(connectorConfig, connectionFactory, this.errorHandler, (EventDispatcher<OraclePartition, TableId>)dispatcher, clock, this.schema, (Configuration)jdbcConfig, this.taskContext, (AbstractOracleStreamingChangeEventSourceMetrics)streamingMetrics, snapshotterService), (ChangeEventSourceMetricsFactory)new OracleChangeEventSourceMetricsFactory((AbstractOracleStreamingChangeEventSourceMetrics)streamingMetrics), dispatcher, (DatabaseSchema)this.schema, signalProcessor, notificationService, snapshotterService);
        coordinator.start((CdcSourceTaskContext)this.taskContext, this.queue, (EventMetadataProvider)metadataProvider);
        return coordinator;
    }

    protected String connectorName() {
        return Module.name();
    }

    private OracleConnection getHeartbeatConnection(OracleConnectorConfig connectorConfig, JdbcConfiguration jdbcConfig) {
        OracleConnection connection = new OracleConnection(jdbcConfig);
        if (!Strings.isNullOrBlank((String)connectorConfig.getPdbName())) {
            connection.setSessionToPdb(connectorConfig.getPdbName());
        }
        return connection;
    }

    public List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        return records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
    }

    protected Optional<ErrorHandler> getErrorHandler() {
        return Optional.of(this.errorHandler);
    }

    public void doStop() {
        try {
            if (this.jdbcConnection != null) {
                this.jdbcConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC connection", (Throwable)e);
        }
        try {
            if (this.beanRegistryJdbcConnection != null) {
                this.beanRegistryJdbcConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC bean registry connection", (Throwable)e);
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return OracleConnectorConfig.ALL_FIELDS;
    }

    public void performCommit() {
        if (!OracleConnectorConfig.ConnectorAdapter.XSTREAM.equals((Object)this.connectorAdapter)) {
            super.performCommit();
            return;
        }
        boolean locked = this.commitLock.tryLock();
        if (!locked) {
            LOGGER.warn("Couldn't commit processed log positions with the source database due to a concurrent connector shutdown or restart");
            return;
        }
        try {
            Offsets offsets = this.getPreviousOffsets(this.partitionProvider, this.offsetContextLoader);
            if (offsets.getOffsets() != null) {
                offsets.getOffsets().entrySet().stream().filter(e -> e.getValue() != null).max(Comparator.comparing(e -> ((OracleOffsetContext)((Object)((Object)e.getValue()))).getLcrPosition())).ifPresent(entry -> {
                    Map<String, String> maxPartition = ((OraclePartition)((Object)((Object)entry.getKey()))).getSourcePartition();
                    Map<String, ?> maxOffset = ((OracleOffsetContext)((Object)((Object)entry.getValue()))).getOffset();
                    LOGGER.debug("Committing LCR offset position '{}'", maxOffset);
                    this.coordinator.commitOffset(maxPartition, maxOffset);
                });
            }
        }
        finally {
            this.commitLock.unlock();
        }
    }

    private void validateRedoLogConfiguration(OracleConnectorConfig config, SnapshotterService snapshotterService) {
        boolean archivelogMode = this.jdbcConnection.isArchiveLogMode();
        if (!archivelogMode) {
            if (OracleConnectorTask.redoLogRequired(config, snapshotterService)) {
                throw new DebeziumException("The Oracle server is not configured to use a archive log LOG_MODE, which is required for this connector to work properly. Change the Oracle configuration to use a LOG_MODE=ARCHIVELOG and restart the connector.");
            }
            LOGGER.warn("Failed the archive log check but continuing as redo log isn't strictly required");
        }
    }

    private void validateGuardrailLimits(OracleConnectorConfig connectorConfig, OracleConnection connection) {
        boolean switchedToPdb = false;
        try {
            if (!Strings.isNullOrEmpty((String)connectorConfig.getPdbName())) {
                connection.setSessionToPdb(connectorConfig.getPdbName());
                switchedToPdb = true;
            }
            Set<TableId> allTableIds = connection.getAllTableIds(connectorConfig.getCatalogName());
            List tableNames = allTableIds.stream().filter(tableId -> connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)).map(TableId::toString).collect(Collectors.toList());
            connectorConfig.validateGuardrailLimits(tableNames.size(), tableNames);
        }
        catch (SQLException e) {
            throw new DebeziumException("Failed to validate guardrail limits", (Throwable)e);
        }
        finally {
            if (switchedToPdb) {
                connection.resetSessionToCdb();
            }
        }
    }

    private static boolean redoLogRequired(OracleConnectorConfig config, SnapshotterService snapshotterService) {
        return snapshotterService.getSnapshotter().shouldStream() || config.getLogMiningTransactionSnapshotBoundaryMode() == OracleConnectorConfig.TransactionSnapshotBoundaryMode.ALL;
    }
}

