/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.logminer.LogMinerQueryBuilder;
import io.debezium.relational.TableId;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class AbstractLogMinerQueryBuilder
implements LogMinerQueryBuilder {
    private static final String EMPTY = "";
    private static final String LOGMNR_CONTENTS_VIEW = "V$LOGMNR_CONTENTS";
    private static final String UNKNOWN_USERNAME = "UNKNOWN";
    private static final String UNKNOWN_SCHEMA_NAME = "UNKNOWN";
    private static final String UNKNOWN_TABLE_NAME_PREFIX = "OBJ#";
    public static final Integer IN_CLAUSE_MAX_ELEMENTS = 1000;
    protected final OracleConnectorConfig connectorConfig;
    protected final boolean useCteQuery;

    public AbstractLogMinerQueryBuilder(OracleConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
        this.useCteQuery = connectorConfig.isLogMiningUseCteQuery();
    }

    @Override
    public String getQuery() {
        String whereClause = this.getPredicates(false);
        StringBuilder query = new StringBuilder(1024);
        if (this.useCteQuery) {
            String cteWhereClause = this.getPredicates(true);
            query.append("WITH relevant_xids AS (").append("SELECT DISTINCT XID as RXID FROM V$LOGMNR_CONTENTS ").append((String)(!Strings.isNullOrBlank((String)cteWhereClause) ? "WHERE " + cteWhereClause : EMPTY)).append(") ");
        }
        query.append("SELECT ");
        if (this.useCteQuery) {
            query.append("/*+ ORDERED USE_NL(R) */ ");
        }
        query.append("SCN, SQL_REDO, OPERATION_CODE, TIMESTAMP, XID, CSF, TABLE_NAME, SEG_OWNER, OPERATION, ").append("USERNAME, ROW_ID, ROLLBACK, RS_ID, STATUS, INFO, SSN, THREAD#, DATA_OBJ#, DATA_OBJV#, DATA_OBJD#, ").append("CLIENT_ID, START_SCN, COMMIT_SCN, START_TIMESTAMP, COMMIT_TIMESTAMP, SEQUENCE# ").append("FROM ").append(LOGMNR_CONTENTS_VIEW).append(" ");
        if (this.useCteQuery) {
            query.append("V JOIN relevant_xids R ON R.RXID = V.XID ");
        }
        return query.append((String)(!Strings.isNullOrEmpty((String)whereClause) ? "WHERE " + whereClause : EMPTY)).toString();
    }

    protected abstract String getPredicates(boolean var1);

    protected String getMultiTenantPredicate() {
        if (!Strings.isNullOrEmpty((String)this.connectorConfig.getPdbName())) {
            return "SRC_CON_NAME = '" + this.connectorConfig.getPdbName() + "'";
        }
        return EMPTY;
    }

    protected String getUserNamePredicate() {
        if (!OracleConnectorConfig.LogMiningQueryFilterMode.NONE.equals((Object)this.connectorConfig.getLogMiningQueryFilterMode())) {
            return IncludeExcludeInClause.builder().withField("USERNAME").withFilterMode(OracleConnectorConfig.LogMiningQueryFilterMode.IN).withDefaultIncludeValues(Collections.singletonList("UNKNOWN")).withIncludeValues(this.connectorConfig.getLogMiningUsernameIncludes()).withExcludeValues(this.connectorConfig.getLogMiningUsernameExcludes()).caseInsensitive().build();
        }
        return EMPTY;
    }

    protected String getClientIdPredicate() {
        if (!OracleConnectorConfig.LogMiningQueryFilterMode.NONE.equals((Object)this.connectorConfig.getLogMiningQueryFilterMode())) {
            return IncludeExcludeInClause.builder().withField("CLIENT_ID").withFilterMode(OracleConnectorConfig.LogMiningQueryFilterMode.IN).withIncludeValues(this.connectorConfig.getLogMiningClientIdIncludes()).withExcludeValues(this.connectorConfig.getLogMiningClientIdExcludes()).caseInsensitive().build();
        }
        return EMPTY;
    }

    protected String getTableNamePredicate() {
        String fieldName = "SEG_OWNER || '.' || TABLE_NAME";
        String includeList = this.connectorConfig.tableIncludeList();
        String excludeList = this.connectorConfig.tableExcludeList();
        OracleConnectorConfig.LogMiningQueryFilterMode queryFilterMode = this.connectorConfig.getLogMiningQueryFilterMode();
        if (OracleConnectorConfig.LogMiningQueryFilterMode.NONE.equals((Object)queryFilterMode)) {
            return EMPTY;
        }
        if (Strings.isNullOrEmpty((String)includeList) && Strings.isNullOrEmpty((String)excludeList)) {
            return EMPTY;
        }
        if (OracleConnectorConfig.LogMiningQueryFilterMode.IN.equals((Object)queryFilterMode)) {
            List<String> includeTableList = AbstractLogMinerQueryBuilder.getTableIncludeExcludeListAsInValueList(includeList);
            List<String> excludeTableList = AbstractLogMinerQueryBuilder.getTableIncludeExcludeListAsInValueList(excludeList);
            StringBuilder predicate = new StringBuilder();
            predicate.append("(TABLE_NAME IS NULL OR ");
            if (this.connectorConfig.getLogMiningStrategy() == OracleConnectorConfig.LogMiningStrategy.HYBRID) {
                predicate.append("TABLE_NAME LIKE '").append(UNKNOWN_TABLE_NAME_PREFIX).append("%' OR ");
            }
            AbstractLogMinerQueryBuilder.getSignalDataCollectionId(this.connectorConfig).ifPresent(signalTableId -> {
                if (!AbstractLogMinerQueryBuilder.tableIncludeListContains(includeTableList, signalTableId)) {
                    predicate.append("UPPER(").append("SEG_OWNER || '.' || TABLE_NAME").append(") = '").append(signalTableId.schema().toUpperCase()).append('.').append(signalTableId.table().toUpperCase()).append("' OR ");
                }
            });
            predicate.append(IncludeExcludeInClause.builder().withField("SEG_OWNER || '.' || TABLE_NAME").withFilterMode(queryFilterMode).withIncludeValues(includeTableList).withExcludeValues(excludeTableList).caseInsensitive().build());
            predicate.append(")");
            return predicate.toString();
        }
        if (OracleConnectorConfig.LogMiningQueryFilterMode.REGEX.equals((Object)queryFilterMode)) {
            List includeTableList = Strings.listOfRegex((String)includeList, (int)2);
            List excludeTableList = Strings.listOfRegex((String)excludeList, (int)2);
            StringBuilder predicate = new StringBuilder();
            predicate.append("(TABLE_NAME IS NULL OR ");
            if (this.connectorConfig.getLogMiningStrategy() == OracleConnectorConfig.LogMiningStrategy.HYBRID) {
                predicate.append("TABLE_NAME LIKE '").append(UNKNOWN_TABLE_NAME_PREFIX).append("%' OR ");
            }
            AbstractLogMinerQueryBuilder.getSignalDataCollectionId(this.connectorConfig).ifPresent(signalTableId -> {
                if (!AbstractLogMinerQueryBuilder.matches(includeTableList, signalTableId.identifier())) {
                    predicate.append("UPPER(").append("SEG_OWNER || '.' || TABLE_NAME").append(") = '").append(signalTableId.schema().toUpperCase()).append('.').append(signalTableId.table().toUpperCase()).append("' OR ");
                }
            });
            predicate.append(IncludeExcludeRegExpLike.builder().withField("SEG_OWNER || '.' || TABLE_NAME").withFilterMode(queryFilterMode).withIncludeValues(includeTableList).withExcludeValues(excludeTableList).build());
            predicate.append(")");
            return predicate.toString();
        }
        throw new DebeziumException("An unsupported LogMiningQueryFilterMode detected: " + String.valueOf((Object)queryFilterMode));
    }

    protected String getSchemaNamePredicate() {
        String fieldName = "SEG_OWNER";
        String includeList = this.connectorConfig.schemaIncludeList();
        String excludeList = this.connectorConfig.schemaExcludeList();
        OracleConnectorConfig.LogMiningQueryFilterMode queryFilterMode = this.connectorConfig.getLogMiningQueryFilterMode();
        if (OracleConnectorConfig.LogMiningQueryFilterMode.NONE.equals((Object)queryFilterMode)) {
            return AbstractLogMinerQueryBuilder.resolveExcludedSchemaPredicate("SEG_OWNER");
        }
        if (Strings.isNullOrEmpty((String)includeList) && Strings.isNullOrEmpty((String)excludeList)) {
            return AbstractLogMinerQueryBuilder.resolveExcludedSchemaPredicate("SEG_OWNER");
        }
        if (OracleConnectorConfig.LogMiningQueryFilterMode.IN.equals((Object)queryFilterMode)) {
            Set includeSchemasList = Strings.setOfTrimmed((String)includeList, String::new);
            Set excludeSchemasList = Strings.setOfTrimmed((String)excludeList, String::new);
            StringBuilder predicate = new StringBuilder();
            predicate.append("(").append("SEG_OWNER").append(" IS NULL OR ");
            predicate.append(IncludeExcludeInClause.builder().withField("SEG_OWNER").withFilterMode(queryFilterMode).withIncludeValues(includeSchemasList).withDefaultIncludeValues(Collections.singletonList("UNKNOWN")).withExcludeValues(excludeSchemasList).withDefaultExcludeValues(AbstractLogMinerQueryBuilder.getBuiltInExcludedSchemas()).caseInsensitive().build());
            predicate.append(")");
            return predicate.toString();
        }
        if (OracleConnectorConfig.LogMiningQueryFilterMode.REGEX.equals((Object)queryFilterMode)) {
            List includeSchemaList = Strings.listOfRegex((String)includeList, (int)2);
            List excludeSchemaList = Strings.listOfRegex((String)excludeList, (int)2);
            StringBuilder predicate = new StringBuilder();
            predicate.append("(");
            predicate.append("SEG_OWNER").append(" IS NULL OR ");
            if (includeSchemaList.isEmpty() && !excludeSchemaList.isEmpty()) {
                predicate.append(InClause.builder().withField("SEG_OWNER").negate().withValues(AbstractLogMinerQueryBuilder.getBuiltInExcludedSchemas()).build());
            } else {
                predicate.append("SEG_OWNER").append(" = '").append("UNKNOWN").append("'");
            }
            predicate.append(" OR ");
            predicate.append(IncludeExcludeRegExpLike.builder().withField("SEG_OWNER").withFilterMode(queryFilterMode).withIncludeValues(includeSchemaList).withExcludeValues(excludeSchemaList).build());
            predicate.append(")");
            return predicate.toString();
        }
        throw new DebeziumException("An unsupported LogMiningQueryFilterMode detected: " + String.valueOf((Object)queryFilterMode));
    }

    private static Optional<TableId> getSignalDataCollectionId(OracleConnectorConfig connectorConfig) {
        if (!Strings.isNullOrEmpty((String)connectorConfig.getSignalingDataCollectionId())) {
            return Optional.of(TableId.parse((String)connectorConfig.getSignalingDataCollectionId()));
        }
        return Optional.empty();
    }

    private static boolean tableIncludeListContains(Collection<String> values, TableId searchValue) {
        for (String value : values) {
            TableId tableId = TableId.parse((String)value, (boolean)false);
            if (!tableId.schema().equalsIgnoreCase(searchValue.schema()) || !tableId.table().equalsIgnoreCase(searchValue.table())) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(Collection<Pattern> patterns, String searchValue) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(searchValue).matches()) continue;
            return true;
        }
        return false;
    }

    private static String resolveExcludedSchemaPredicate(String fieldName) {
        List<String> schemas = AbstractLogMinerQueryBuilder.getBuiltInExcludedSchemas();
        if (!schemas.isEmpty()) {
            StringBuilder query = new StringBuilder();
            query.append('(').append(fieldName).append(" IS NULL OR ");
            query.append(InClause.builder().withField(fieldName).negate().withValues(schemas).build());
            query.append(')');
            return query.toString();
        }
        return EMPTY;
    }

    private static List<String> getBuiltInExcludedSchemas() {
        return AbstractLogMinerQueryBuilder.toUpperCase(OracleConnectorConfig.EXCLUDED_SCHEMAS);
    }

    private static List<String> getTableIncludeExcludeListAsInValueList(String list) {
        return Strings.listOfTrimmed((String)list, s -> s.split("[,]"), v -> v.replaceAll("\\\\", EMPTY));
    }

    private static List<String> toUpperCase(Collection<String> values) {
        return values.stream().map(String::toUpperCase).collect(Collectors.toList());
    }

    private static class IncludeExcludeInClause {
        private String fieldName;
        private boolean caseInsensitive;
        private OracleConnectorConfig.LogMiningQueryFilterMode mode;
        private List<Object> defaultIncludeValues;
        private List<Object> includeValues;
        private List<Object> defaultExcludeValues;
        private List<Object> excludeValues;

        private IncludeExcludeInClause() {
        }

        public static IncludeExcludeInClause builder() {
            return new IncludeExcludeInClause();
        }

        public IncludeExcludeInClause caseInsensitive() {
            this.caseInsensitive = true;
            return this;
        }

        public IncludeExcludeInClause withField(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public IncludeExcludeInClause withFilterMode(OracleConnectorConfig.LogMiningQueryFilterMode mode) {
            this.mode = mode;
            return this;
        }

        public IncludeExcludeInClause withDefaultIncludeValues(Collection<?> values) {
            this.defaultIncludeValues = new ArrayList(values);
            return this;
        }

        public IncludeExcludeInClause withIncludeValues(Collection<?> values) {
            this.includeValues = new ArrayList(values);
            return this;
        }

        public IncludeExcludeInClause withDefaultExcludeValues(Collection<?> values) {
            this.defaultExcludeValues = new ArrayList(values);
            return this;
        }

        public IncludeExcludeInClause withExcludeValues(Collection<?> values) {
            this.excludeValues = new ArrayList(values);
            return this;
        }

        public String build() {
            Objects.requireNonNull(this.includeValues, "The include values must not be null");
            Objects.requireNonNull(this.excludeValues, "The exclude values must not be null");
            Objects.requireNonNull(this.mode, "The LogMiningQueryFilterMode must not be null");
            if (OracleConnectorConfig.LogMiningQueryFilterMode.NONE.equals((Object)this.mode) || this.includeValues.isEmpty() && this.excludeValues.isEmpty()) {
                return AbstractLogMinerQueryBuilder.EMPTY;
            }
            if (!OracleConnectorConfig.LogMiningQueryFilterMode.IN.equals((Object)this.mode)) {
                throw new IllegalStateException("Expected LogMiningQueryFilterMode to be IN");
            }
            InClause inClause = InClause.builder().withField(this.fieldName);
            if (this.caseInsensitive) {
                inClause.caseInsensitive();
            }
            if (!this.excludeValues.isEmpty()) {
                if (this.defaultExcludeValues != null && !this.defaultExcludeValues.isEmpty()) {
                    this.defaultExcludeValues.addAll(this.excludeValues);
                    inClause.negate().withValues(this.defaultExcludeValues);
                } else {
                    inClause.negate().withValues(this.excludeValues);
                }
            } else if (this.defaultIncludeValues != null && !this.defaultIncludeValues.isEmpty()) {
                this.defaultIncludeValues.addAll(this.includeValues);
                inClause.withValues(this.defaultIncludeValues);
            } else {
                inClause.withValues(this.includeValues);
            }
            return inClause.build();
        }
    }

    private static class IncludeExcludeRegExpLike {
        private String fieldName;
        private OracleConnectorConfig.LogMiningQueryFilterMode mode;
        private List<Pattern> includeValues;
        private List<Pattern> excludeValues;

        private IncludeExcludeRegExpLike() {
        }

        public static IncludeExcludeRegExpLike builder() {
            return new IncludeExcludeRegExpLike();
        }

        public IncludeExcludeRegExpLike withField(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public IncludeExcludeRegExpLike withFilterMode(OracleConnectorConfig.LogMiningQueryFilterMode mode) {
            this.mode = mode;
            return this;
        }

        public IncludeExcludeRegExpLike withIncludeValues(Collection<Pattern> values) {
            this.includeValues = new ArrayList<Pattern>(values);
            return this;
        }

        public IncludeExcludeRegExpLike withExcludeValues(Collection<Pattern> values) {
            this.excludeValues = new ArrayList<Pattern>(values);
            return this;
        }

        public String build() {
            Objects.requireNonNull(this.includeValues, "The include values must not be null");
            Objects.requireNonNull(this.excludeValues, "The exclude values must not be null");
            Objects.requireNonNull(this.mode, "The LogMiningQueryFilterMode must not be null");
            if (OracleConnectorConfig.LogMiningQueryFilterMode.NONE.equals((Object)this.mode) || this.includeValues.isEmpty() && this.excludeValues.isEmpty()) {
                return AbstractLogMinerQueryBuilder.EMPTY;
            }
            if (!OracleConnectorConfig.LogMiningQueryFilterMode.REGEX.equals((Object)this.mode)) {
                throw new IllegalStateException("Expected LogMiningQueryFilterMode to be REGEX");
            }
            List<Pattern> values = !this.excludeValues.isEmpty() ? this.excludeValues : this.includeValues;
            String prepend = !this.excludeValues.isEmpty() ? "NOT " : AbstractLogMinerQueryBuilder.EMPTY;
            String junction = !this.excludeValues.isEmpty() ? " AND " : " OR ";
            StringBuilder sql = new StringBuilder();
            sql.append("(");
            Iterator<Pattern> iterator = values.iterator();
            while (iterator.hasNext()) {
                sql.append(prepend);
                sql.append(this.regularExpressionLike(iterator.next()));
                if (!iterator.hasNext()) continue;
                sql.append(junction);
            }
            sql.append(")");
            return sql.toString();
        }

        private String regularExpressionLike(Pattern pattern) {
            return "REGEXP_LIKE(" + this.fieldName + ",'" + this.preparePattern(pattern) + "','i')";
        }

        private String preparePattern(Pattern pattern) {
            Object patternText = pattern.pattern();
            if (!((String)patternText).startsWith("^")) {
                patternText = "^" + (String)patternText;
            }
            if (!((String)patternText).endsWith("$")) {
                patternText = (String)patternText + "$";
            }
            return patternText;
        }
    }

    protected static class InClause {
        private String fieldName;
        private boolean negated;
        private boolean caseInsensitive;
        private Collection<?> values;

        private InClause() {
        }

        public static InClause builder() {
            return new InClause();
        }

        public InClause withField(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public InClause negate() {
            this.negated = true;
            return this;
        }

        public InClause caseInsensitive() {
            this.caseInsensitive = true;
            return this;
        }

        public InClause withValues(Collection<?> values) {
            this.values = values;
            return this;
        }

        public String build() {
            Objects.requireNonNull(this.fieldName, "The field name must not be null");
            Objects.requireNonNull(this.values, "The values list must not be null");
            StringBuilder sql = new StringBuilder();
            List<Object> listValues = Arrays.asList(this.values.toArray());
            int buckets = (listValues.size() + IN_CLAUSE_MAX_ELEMENTS - 1) / IN_CLAUSE_MAX_ELEMENTS;
            for (int i = 0; i < buckets; ++i) {
                if (i > 0) {
                    sql.append(this.negated ? " AND " : " OR ");
                }
                if (this.caseInsensitive) {
                    sql.append("UPPER(").append(this.fieldName).append(")");
                } else {
                    sql.append(this.fieldName);
                }
                if (this.negated) {
                    sql.append(" NOT");
                }
                int startIndex = i * IN_CLAUSE_MAX_ELEMENTS;
                int endIndex = startIndex + Math.min(IN_CLAUSE_MAX_ELEMENTS, listValues.size() - startIndex);
                sql.append(" IN (").append(this.commaSeparatedList(listValues.subList(startIndex, endIndex))).append(")");
            }
            return listValues.size() > IN_CLAUSE_MAX_ELEMENTS ? "(" + String.valueOf(sql) + ")" : sql.toString();
        }

        private String commaSeparatedList(Collection<?> values) {
            StringBuilder list = new StringBuilder();
            Iterator<?> iterator = values.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (value instanceof String) {
                    list.append("'").append(this.sanitizeCommaSeparatedStringElement((String)value)).append("'");
                } else {
                    list.append(value);
                }
                if (!iterator.hasNext()) continue;
                list.append(",");
            }
            return list.toString();
        }

        private String sanitizeCommaSeparatedStringElement(String element) {
            if (this.caseInsensitive) {
                return element.trim().toUpperCase();
            }
            return element.trim();
        }
    }
}

