/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.jdbc.ConnectionFactory;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.util.Strings;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;

public class OracleConnectionFactory
implements MainConnectionProvidingConnectionFactory<OracleConnection> {
    private final ConnectionFactory<OracleConnection> mainConnectionFactory = () -> new OracleConnection(connectorConfig);
    private final ConnectionFactory<OracleConnection> readOnlyConnectionFactory;
    private final OracleConnection mainConnection;
    private final OracleConnection readOnlyConnection;

    public OracleConnectionFactory(OracleConnectorConfig connectorConfig) {
        this.readOnlyConnectionFactory = OracleConnectionFactory.buildReadOnlyConnectionFactory(connectorConfig);
        this.mainConnection = (OracleConnection)this.mainConnectionFactory.newConnection();
        this.readOnlyConnection = this.readOnlyConnectionFactory != null ? (OracleConnection)this.readOnlyConnectionFactory.newConnection() : null;
    }

    public OracleConnection getConnection() {
        return this.readOnlyConnection != null ? this.readOnlyConnection : this.mainConnection;
    }

    public OracleConnection mainConnection() {
        return this.mainConnection;
    }

    public OracleConnection newConnection() {
        return (OracleConnection)this.mainConnectionFactory.newConnection();
    }

    private static ConnectionFactory<OracleConnection> buildReadOnlyConnectionFactory(OracleConnectorConfig connectorConfig) {
        return connectorConfig.isLogMiningReadOnly() ? new ReadOnlyConnectionFactory(connectorConfig) : null;
    }

    private static class ReadOnlyConnectionFactory
    implements ConnectionFactory<OracleConnection> {
        private final ConnectionFactory<OracleConnection> delegate = () -> new OracleConnection(connectorConfig, ReadOnlyConnectionFactory.buildReadOnlyConfig(connectorConfig)){

            public synchronized Connection connection(boolean executeOnConnect) throws SQLException {
                Connection connection = super.connection(executeOnConnect);
                connection.setReadOnly(true);
                return connection;
            }
        };

        ReadOnlyConnectionFactory(OracleConnectorConfig connectorConfig) {
        }

        public OracleConnection newConnection() {
            return (OracleConnection)this.delegate.newConnection();
        }

        private static JdbcConfiguration buildReadOnlyConfig(OracleConnectorConfig connectorConfig) {
            if (Strings.isNullOrEmpty((String)connectorConfig.getReadonlyHostname())) {
                throw new DebeziumException("Cannot create read only connection, read only hostname is empty");
            }
            Map jdbcConfig = connectorConfig.getJdbcConfig().asMap();
            jdbcConfig.put("hostname", connectorConfig.getReadonlyHostname());
            return JdbcConfiguration.adapt((Configuration)Configuration.from((Map)jdbcConfig));
        }
    }
}

