/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.SnapshotType;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.oracle.CommitScn;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.SourceInfo;
import io.debezium.pipeline.CommonOffsetContext;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Strings;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;

public class OracleOffsetContext
extends CommonOffsetContext<SourceInfo> {
    public static final String SNAPSHOT_PENDING_TRANSACTIONS_KEY = "snapshot_pending_tx";
    public static final String SNAPSHOT_SCN_KEY = "snapshot_scn";
    private final Schema sourceInfoSchema;
    private final TransactionContext transactionContext;
    private final IncrementalSnapshotContext<TableId> incrementalSnapshotContext;
    private final Scn snapshotScn;
    private Map<String, Scn> snapshotPendingTransactions;

    private OracleOffsetContext(OracleConnectorConfig connectorConfig, Scn scn, Long scnIndex, CommitScn commitScn, String lcrPosition, Scn snapshotScn, Map<String, Scn> snapshotPendingTransactions, SnapshotType snapshot, boolean snapshotCompleted, TransactionContext transactionContext, IncrementalSnapshotContext<TableId> incrementalSnapshotContext, String transactionId, Long transactionSequence) {
        super((BaseSourceInfo)new SourceInfo(connectorConfig), snapshotCompleted);
        ((SourceInfo)this.sourceInfo).setScn(scn);
        ((SourceInfo)this.sourceInfo).setScnIndex(scnIndex);
        ((SourceInfo)this.sourceInfo).setTransactionId(transactionId);
        ((SourceInfo)this.sourceInfo).setTransactionSequence(transactionSequence);
        ((SourceInfo)this.sourceInfo).setEventScn(scn);
        ((SourceInfo)this.sourceInfo).setLcrPosition(lcrPosition);
        ((SourceInfo)this.sourceInfo).setCommitScn(commitScn);
        this.sourceInfoSchema = ((SourceInfo)this.sourceInfo).schema();
        this.snapshotScn = snapshotScn == null ? Scn.NULL : snapshotScn;
        this.snapshotPendingTransactions = snapshotPendingTransactions;
        this.transactionContext = transactionContext;
        this.incrementalSnapshotContext = incrementalSnapshotContext;
        if (this.snapshotCompleted) {
            this.postSnapshotCompletion();
        } else {
            this.setSnapshot(snapshot);
            ((SourceInfo)this.sourceInfo).setSnapshot(snapshot != null ? SnapshotRecord.TRUE : SnapshotRecord.FALSE);
        }
    }

    public static Builder create() {
        return new Builder();
    }

    public Map<String, ?> getOffset() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.getSnapshot().isPresent()) {
            result.put("snapshot", ((SnapshotType)this.getSnapshot().get()).toString());
            result.put("snapshot_completed", this.snapshotCompleted);
            String encodedPendingTransactions = this.getEncodedSnapshotPendingTransactions();
            if (!Strings.isNullOrEmpty((String)encodedPendingTransactions)) {
                result.put(SNAPSHOT_PENDING_TRANSACTIONS_KEY, encodedPendingTransactions);
            }
        }
        if (((SourceInfo)this.sourceInfo).getLcrPosition() != null) {
            result.put("lcr_position", ((SourceInfo)this.sourceInfo).getLcrPosition());
        } else {
            if (((SourceInfo)this.sourceInfo).getScn() != null) {
                result.put("scn", ((SourceInfo)this.sourceInfo).getScn().toString());
            }
            if (((SourceInfo)this.sourceInfo).getScnIndex() != null) {
                result.put("scn_idx", ((SourceInfo)this.sourceInfo).getScnIndex());
            }
        }
        if (this.snapshotScn != null && !this.snapshotScn.isNull()) {
            result.put(SNAPSHOT_SCN_KEY, this.snapshotScn.toString());
        }
        if (((SourceInfo)this.sourceInfo).getCommitScn() != null) {
            ((SourceInfo)this.sourceInfo).getCommitScn().store(result);
        }
        if (((SourceInfo)this.sourceInfo).getTransactionId() != null) {
            result.put("txId", ((SourceInfo)this.sourceInfo).getTransactionId());
            if (((SourceInfo)this.sourceInfo).getTransactionSequence() != null) {
                result.put("txSeq", ((SourceInfo)this.sourceInfo).getTransactionSequence());
            }
        }
        return ((SourceInfo)this.sourceInfo).isSnapshot() ? result : this.incrementalSnapshotContext.store(this.transactionContext.store(result));
    }

    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    public void setScn(Scn scn) {
        ((SourceInfo)this.sourceInfo).setScn(scn);
    }

    public void setScnIndex(Long scnIndex) {
        ((SourceInfo)this.sourceInfo).setScnIndex(scnIndex);
    }

    public void setEventScn(Scn eventScn) {
        ((SourceInfo)this.sourceInfo).setEventScn(eventScn);
    }

    public void setEventCommitScn(Scn eventCommitScn) {
        ((SourceInfo)this.sourceInfo).setEventCommitScn(eventCommitScn);
    }

    public Scn getScn() {
        return ((SourceInfo)this.sourceInfo).getScn();
    }

    public Long getScnIndex() {
        return ((SourceInfo)this.sourceInfo).getScnIndex();
    }

    public CommitScn getCommitScn() {
        return ((SourceInfo)this.sourceInfo).getCommitScn();
    }

    public Instant getCommitTime() {
        return ((SourceInfo)this.sourceInfo).getCommitTime();
    }

    public Scn getEventScn() {
        return ((SourceInfo)this.sourceInfo).getEventScn();
    }

    public Scn getEventCommitScn() {
        return ((SourceInfo)this.sourceInfo).getEventCommitScn();
    }

    public void setLcrPosition(String lcrPosition) {
        ((SourceInfo)this.sourceInfo).setLcrPosition(lcrPosition);
    }

    public String getLcrPosition() {
        return ((SourceInfo)this.sourceInfo).getLcrPosition();
    }

    public Scn getSnapshotScn() {
        return this.snapshotScn;
    }

    public Map<String, Scn> getSnapshotPendingTransactions() {
        return this.snapshotPendingTransactions;
    }

    public String getTransactionId() {
        return ((SourceInfo)this.sourceInfo).getTransactionId();
    }

    public Long getTransactionSequence() {
        return ((SourceInfo)this.sourceInfo).getTransactionSequence();
    }

    public void setSnapshotPendingTransactions(Map<String, Scn> snapshotPendingTransactions) {
        this.snapshotPendingTransactions = snapshotPendingTransactions;
    }

    public void setTransactionId(String transactionId) {
        ((SourceInfo)this.sourceInfo).setTransactionId(transactionId);
    }

    public void setTransactionSequence(Long transactionSequence) {
        ((SourceInfo)this.sourceInfo).setTransactionSequence(transactionSequence);
    }

    public void setUserName(String userName) {
        ((SourceInfo)this.sourceInfo).setUserName(userName);
    }

    public void setSourceTime(Instant instant) {
        ((SourceInfo)this.sourceInfo).setSourceTime(instant);
    }

    public void setTableId(TableId tableId) {
        ((SourceInfo)this.sourceInfo).tableEvent(tableId);
    }

    public Integer getRedoThread() {
        return ((SourceInfo)this.sourceInfo).getRedoThread();
    }

    public void setRedoThread(Integer redoThread) {
        ((SourceInfo)this.sourceInfo).setRedoThread(redoThread);
    }

    public void setRsId(String rsId) {
        ((SourceInfo)this.sourceInfo).setRsId(rsId);
    }

    public void setSsn(long ssn) {
        ((SourceInfo)this.sourceInfo).setSsn(ssn);
    }

    public void setStartScn(Scn startScn) {
        ((SourceInfo)this.sourceInfo).setStartScn(startScn);
    }

    public void setStartTime(Instant startTime) {
        ((SourceInfo)this.sourceInfo).setStartTime(startTime);
    }

    public void setCommitTime(Instant commitTime) {
        ((SourceInfo)this.sourceInfo).setCommitTime(commitTime);
    }

    public String getRedoSql() {
        return ((SourceInfo)this.sourceInfo).getRedoSql();
    }

    public void setRedoSql(String redoSql) {
        ((SourceInfo)this.sourceInfo).setRedoSql(redoSql);
    }

    public String getRowId() {
        return ((SourceInfo)this.sourceInfo).getRowId();
    }

    public void setRowId(String rowId) {
        ((SourceInfo)this.sourceInfo).setRowId(rowId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OracleOffsetContext [scn=").append(this.getScn());
        if (this.getSnapshot().isPresent()) {
            sb.append(", snapshot=").append(this.getSnapshot().get());
            sb.append(", snapshot_completed=").append(this.snapshotCompleted);
        } else if (this.getScnIndex() != null) {
            sb.append(", scnIndex=").append(this.getScnIndex());
        }
        if (this.getTransactionId() != null) {
            sb.append(", txId=").append(this.getTransactionId());
            if (this.getTransactionSequence() != null) {
                sb.append(", txSeq=").append(this.getTransactionSequence());
            }
        }
        sb.append(", commit_scn=").append(((SourceInfo)this.sourceInfo).getCommitScn().toLoggableFormat());
        sb.append(", lcr_position=").append(((SourceInfo)this.sourceInfo).getLcrPosition());
        sb.append("]");
        return sb.toString();
    }

    public void event(DataCollectionId tableId, Instant timestamp) {
        ((SourceInfo)this.sourceInfo).tableEvent((TableId)tableId);
        ((SourceInfo)this.sourceInfo).setSourceTime(timestamp);
    }

    public void tableEvent(TableId tableId, Instant timestamp) {
        ((SourceInfo)this.sourceInfo).setSourceTime(timestamp);
        ((SourceInfo)this.sourceInfo).tableEvent(tableId);
    }

    public void tableEvent(Set<TableId> tableIds, Instant timestamp) {
        ((SourceInfo)this.sourceInfo).setSourceTime(timestamp);
        ((SourceInfo)this.sourceInfo).tableEvent(tableIds);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public IncrementalSnapshotContext<?> getIncrementalSnapshotContext() {
        return this.incrementalSnapshotContext;
    }

    private String getEncodedSnapshotPendingTransactions() {
        if (this.snapshotPendingTransactions == null || this.snapshotPendingTransactions.isEmpty()) {
            return null;
        }
        return this.snapshotPendingTransactions.entrySet().stream().map(e -> (String)e.getKey() + ":" + ((Scn)e.getValue()).toString()).collect(Collectors.joining(","));
    }

    public static Scn getScnFromOffsetMapByKey(Map<String, ?> offset, String key) {
        Object scn = offset.get(key);
        if (scn instanceof String) {
            return Scn.valueOf((String)scn);
        }
        if (scn != null) {
            return Scn.valueOf((Long)scn);
        }
        return null;
    }

    public static Map<String, Scn> loadSnapshotPendingTransactions(Map<String, ?> offset) {
        HashMap<String, Scn> snapshotPendingTransactions = new HashMap<String, Scn>();
        String encoded = OracleOffsetContext.readOffsetValue(offset, SNAPSHOT_PENDING_TRANSACTIONS_KEY, String.class);
        if (encoded != null) {
            Arrays.stream(encoded.split(",")).map(String::trim).filter(s -> !s.isEmpty()).forEach(e -> {
                String[] parts = e.split(":", 2);
                String txid = parts[0];
                Scn startScn = Scn.valueOf(parts[1]);
                snapshotPendingTransactions.put(txid, startScn);
            });
        }
        return snapshotPendingTransactions;
    }

    public static Scn loadSnapshotScn(Map<String, ?> offset) {
        return OracleOffsetContext.getScnFromOffsetMapByKey(offset, SNAPSHOT_SCN_KEY);
    }

    public static String loadTransactionId(Map<String, ?> offset) {
        return OracleOffsetContext.readOffsetValue(offset, "txId", String.class);
    }

    public static Long loadTransactionSequence(Map<String, ?> offset) {
        return OracleOffsetContext.readOffsetValue(offset, "txSeq", Long.class);
    }

    private static <T> T readOffsetValue(Map<String, ?> offsets, String key, Class<T> valueType) {
        Object value = offsets.get(key);
        return valueType.isInstance(value) ? (T)valueType.cast(value) : null;
    }

    public static class Builder {
        private OracleConnectorConfig connectorConfig;
        private Scn scn;
        private Long scnIndex;
        private String lcrPosition;
        private SnapshotType snapshot;
        private boolean snapshotCompleted;
        private TransactionContext transactionContext;
        private IncrementalSnapshotContext<TableId> incrementalSnapshotContext;
        private Map<String, Scn> snapshotPendingTransactions;
        private Scn snapshotScn;
        private String transactionId;
        private Long transactionSequence;
        private CommitScn commitScn = CommitScn.empty();

        public Builder logicalName(OracleConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
            return this;
        }

        public Builder scn(Scn scn) {
            this.scn = scn;
            return this;
        }

        public Builder scnIndex(Long scnIndex) {
            this.scnIndex = scnIndex;
            return this;
        }

        public Builder lcrPosition(String lcrPosition) {
            this.lcrPosition = lcrPosition;
            return this;
        }

        public Builder snapshot(SnapshotType snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder snapshotCompleted(boolean snapshotCompleted) {
            this.snapshotCompleted = snapshotCompleted;
            return this;
        }

        public Builder transactionContext(TransactionContext transactionContext) {
            this.transactionContext = transactionContext;
            return this;
        }

        public Builder incrementalSnapshotContext(IncrementalSnapshotContext<TableId> incrementalSnapshotContext) {
            this.incrementalSnapshotContext = incrementalSnapshotContext;
            return this;
        }

        public Builder snapshotPendingTransactions(Map<String, Scn> snapshotPendingTransactions) {
            this.snapshotPendingTransactions = snapshotPendingTransactions;
            return this;
        }

        public Builder snapshotScn(Scn scn) {
            this.snapshotScn = scn;
            return this;
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder transactionSequence(Long transactionSequence) {
            this.transactionSequence = transactionSequence;
            return this;
        }

        public Builder commitScn(CommitScn commitScn) {
            this.commitScn = commitScn;
            return this;
        }

        public OracleOffsetContext build() {
            return new OracleOffsetContext(this.connectorConfig, this.scn, this.scnIndex, this.commitScn, this.lcrPosition, this.snapshotScn, this.snapshotPendingTransactions, this.snapshot, this.snapshotCompleted, this.transactionContext, this.incrementalSnapshotContext, this.transactionId, this.transactionSequence);
        }
    }
}

