/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.oracle.CommitScn;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.SourceInfo;
import io.debezium.util.Strings;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class OracleSourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private Schema schema;

    public void init(String connector, String version, CommonConnectorConfig connectorConfig) {
        super.init(connector, version, connectorConfig);
        this.schema = CommitScn.schemaBuilder(this.commonSchemaBuilder().name("io.debezium.connector.oracle.Source").field("schema", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).field("txId", Schema.OPTIONAL_STRING_SCHEMA).field("scn", Schema.OPTIONAL_STRING_SCHEMA).field("commit_scn", Schema.OPTIONAL_STRING_SCHEMA).field("lcr_position", Schema.OPTIONAL_STRING_SCHEMA).field("rs_id", Schema.OPTIONAL_STRING_SCHEMA).field("ssn", Schema.OPTIONAL_INT64_SCHEMA)).field("user_name", Schema.OPTIONAL_STRING_SCHEMA).field("redo_sql", Schema.OPTIONAL_STRING_SCHEMA).field("row_id", Schema.OPTIONAL_STRING_SCHEMA).field("commit_ts_ms", Schema.OPTIONAL_INT64_SCHEMA).field("start_scn", Schema.OPTIONAL_STRING_SCHEMA).field("start_ts_ms", Schema.OPTIONAL_INT64_SCHEMA).field("txSeq", Schema.OPTIONAL_INT64_SCHEMA).build();
    }

    public Schema schema() {
        return this.schema;
    }

    public Struct struct(SourceInfo sourceInfo) {
        String eventScn = sourceInfo.getEventScn() == null ? null : sourceInfo.getEventScn().toString();
        Struct ret = super.commonStruct((AbstractSourceInfo)sourceInfo).put("schema", (Object)sourceInfo.tableSchema()).put("table", (Object)sourceInfo.table()).put("txId", (Object)sourceInfo.getTransactionId()).put("txSeq", (Object)sourceInfo.getTransactionSequence()).put("scn", (Object)eventScn);
        if (sourceInfo.getLcrPosition() != null) {
            ret.put("lcr_position", (Object)sourceInfo.getLcrPosition());
        }
        if (sourceInfo.getUserName() != null) {
            ret.put("user_name", (Object)sourceInfo.getUserName());
        }
        if (sourceInfo.getRsId() != null) {
            ret.put("rs_id", (Object)sourceInfo.getRsId());
        }
        if (!Strings.isNullOrBlank((String)sourceInfo.getRedoSql())) {
            ret.put("redo_sql", (Object)sourceInfo.getRedoSql());
        }
        if (!Strings.isNullOrBlank((String)sourceInfo.getRowId())) {
            ret.put("row_id", (Object)sourceInfo.getRowId());
        }
        ret.put("ssn", (Object)sourceInfo.getSsn());
        ret.put("redo_thread", (Object)sourceInfo.getRedoThread());
        Scn eventCommitScn = sourceInfo.getEventCommitScn();
        if (eventCommitScn != null && !eventCommitScn.isNull()) {
            ret.put("commit_scn", (Object)eventCommitScn.toString());
        }
        if (sourceInfo.getCommitTime() != null) {
            ret.put("commit_ts_ms", (Object)sourceInfo.getCommitTime().toEpochMilli());
        }
        if (sourceInfo.getStartScn() != null && !sourceInfo.getStartScn().isNull()) {
            ret.put("start_scn", (Object)sourceInfo.getStartScn().toString());
        }
        if (sourceInfo.getStartTime() != null) {
            ret.put("start_ts_ms", (Object)sourceInfo.getStartTime().toEpochMilli());
        }
        return ret;
    }
}

