/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered.memory;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.logminer.buffered.AbstractCacheProvider;
import io.debezium.connector.oracle.logminer.buffered.LogMinerCache;
import io.debezium.connector.oracle.logminer.buffered.LogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.memory.MemoryBasedLogMinerCache;
import io.debezium.connector.oracle.logminer.buffered.memory.MemoryLogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.memory.MemoryTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCacheProvider
extends AbstractCacheProvider<MemoryTransaction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryCacheProvider.class);
    private final MemoryLogMinerTransactionCache transactionCache;
    private final MemoryBasedLogMinerCache<String, String> processedTransactionsCache;
    private final MemoryBasedLogMinerCache<String, String> schemaChangesCache;

    public MemoryCacheProvider(OracleConnectorConfig connectorConfig) {
        LOGGER.info("Using Java heap to buffer transactions");
        this.transactionCache = new MemoryLogMinerTransactionCache();
        this.processedTransactionsCache = new MemoryBasedLogMinerCache();
        this.schemaChangesCache = new MemoryBasedLogMinerCache();
    }

    @Override
    public LogMinerTransactionCache<MemoryTransaction> getTransactionCache() {
        return this.transactionCache;
    }

    @Override
    public LogMinerCache<String, String> getSchemaChangesCache() {
        return this.schemaChangesCache;
    }

    @Override
    public LogMinerCache<String, String> getProcessedTransactionsCache() {
        return this.processedTransactionsCache;
    }

    @Override
    public void close() throws Exception {
    }
}

