/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.parser;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlParser;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import java.util.HashMap;
import java.util.Map;

public class LogMinerColumnResolverDmlParser
extends LogMinerDmlParser {
    private Map<TableId, Map<String, Integer>> tableColumnPositionCache = new HashMap<TableId, Map<String, Integer>>();

    public LogMinerColumnResolverDmlParser(OracleConnectorConfig connectorConfig) {
        super(connectorConfig);
    }

    @Override
    protected int getColumnIndexByName(String columnName, Table table) {
        if (columnName.matches("COL \\d*")) {
            Integer position;
            Map<String, Integer> tableColumnPositions = this.tableColumnPositionCache.get(table.id());
            if (tableColumnPositions == null || !tableColumnPositions.containsKey(columnName)) {
                tableColumnPositions = this.updateTableColumnPositionCache(table);
            }
            if ((position = tableColumnPositions.get(columnName)) == null) {
                throw new DebeziumException("Failed to find column " + columnName + " in table column position cache");
            }
            return position;
        }
        return super.getColumnIndexByName(columnName, table);
    }

    public void removeTableFromCache(TableId tableId) {
        this.tableColumnPositionCache.remove(tableId);
    }

    private Map<String, Integer> updateTableColumnPositionCache(Table table) {
        HashMap<String, Integer> tableColumnPositions = new HashMap<String, Integer>();
        int generatedColumns = 0;
        for (Column column : table.columns()) {
            if (column.isGenerated()) {
                ++generatedColumns;
                continue;
            }
            String columnName = String.format("COL %d", column.position() - generatedColumns);
            tableColumnPositions.put(columnName, column.position() - 1);
        }
        this.tableColumnPositionCache.put(table.id(), tableColumnPositions);
        return tableColumnPositions;
    }
}

