/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.spi;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.logminer.buffered.BufferedLogMinerStreamingChangeEventSource;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.signal.SignalPayload;
import io.debezium.pipeline.signal.actions.SignalAction;
import io.debezium.pipeline.spi.Partition;
import io.debezium.util.Strings;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTransactionAction<P extends Partition>
implements SignalAction<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropTransactionAction.class);
    public static final String NAME = "drop-transaction";
    private static final String FIELD_TRANSACTION_ID = "transaction-id";
    private final ChangeEventSourceCoordinator<P, ?> changeEventSourceCoordinator;

    public DropTransactionAction(ChangeEventSourceCoordinator<P, ?> changeEventSourceCoordinator) {
        this.changeEventSourceCoordinator = changeEventSourceCoordinator;
    }

    public boolean arrived(SignalPayload<P> signalPayload) throws InterruptedException {
        LOGGER.info("Processing {} signal: {}", (Object)NAME, (Object)signalPayload.id);
        if (!(signalPayload.partition instanceof OraclePartition)) {
            throw new DebeziumException(String.format("Signal '%s' with id '%s' is only supported by Oracle connector, but was sent to connector handling partition type: %s", NAME, signalPayload.id, signalPayload.partition.getClass().getSimpleName()));
        }
        String transactionId = signalPayload.data.getString((CharSequence)FIELD_TRANSACTION_ID);
        if (Strings.isNullOrEmpty((String)transactionId)) {
            LOGGER.warn("Drop transaction signal '{}' has arrived but the required field '{}' is missing or empty from data", (Object)signalPayload.id, (Object)FIELD_TRANSACTION_ID);
            return false;
        }
        BufferedLogMinerStreamingChangeEventSource source = this.getStreamingSource();
        if (source == null) {
            LOGGER.warn("Cannot process drop transaction signal '{}' - streaming source is not available", (Object)signalPayload.id);
            return false;
        }
        String txId = transactionId.trim().toLowerCase();
        LOGGER.info("Attempting to drop transaction '{}' from Oracle LogMiner buffer as requested by signal '{}'", (Object)txId, (Object)signalPayload.id);
        boolean success = source.abandonTransactionById(txId);
        if (success) {
            LOGGER.info("Successfully dropped transaction '{}' from Oracle LogMiner buffer via signal '{}'", (Object)txId, (Object)signalPayload.id);
        } else {
            LOGGER.warn("Transaction '{}' was not found in Oracle LogMiner buffer or could not be dropped via signal '{}'", (Object)txId, (Object)signalPayload.id);
        }
        return success;
    }

    private BufferedLogMinerStreamingChangeEventSource getStreamingSource() {
        Optional source = this.changeEventSourceCoordinator.getStreamingSource();
        if (source.isEmpty()) {
            return null;
        }
        return source.filter(BufferedLogMinerStreamingChangeEventSource.class::isInstance).map(BufferedLogMinerStreamingChangeEventSource.class::cast).orElseThrow(() -> new DebeziumException(String.format("Signal '%s' is only supported by BufferedLogMinerStreamingChangeEventSource, but found %s", NAME, source.get().getClass().getSimpleName())));
    }
}

