/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.connection.Lsn;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.relational.TableId;
import java.time.Instant;
import java.util.ArrayList;

@NotThreadSafe
public final class SourceInfo
extends BaseSourceInfo {
    public static final String TIMESTAMP_USEC_KEY = "ts_usec";
    public static final String TXID_KEY = "txId";
    public static final String XMIN_KEY = "xmin";
    public static final String LSN_KEY = "lsn";
    public static final String MSG_TYPE_KEY = "messageType";
    public static final String LAST_SNAPSHOT_RECORD_KEY = "last_snapshot_record";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String dbName;
    private Lsn lsn;
    private Lsn lastCommitLsn;
    private Long txId;
    private Long xmin;
    private ReplicationMessage.Operation messageType;
    private Instant timestamp;
    private String schemaName;
    private String tableName;

    protected SourceInfo(PostgresConnectorConfig connectorConfig) {
        super((CommonConnectorConfig)connectorConfig);
        this.dbName = connectorConfig.databaseName();
    }

    protected SourceInfo update(Lsn lsn, Instant commitTime, Long txId, Long xmin, TableId tableId, ReplicationMessage.Operation messageType) {
        this.lsn = lsn;
        if (commitTime != null) {
            this.timestamp = commitTime;
        }
        this.txId = txId;
        this.xmin = xmin;
        if (messageType != null) {
            this.messageType = messageType;
        }
        this.schemaName = tableId != null && tableId.schema() != null ? tableId.schema() : "";
        this.tableName = tableId != null && tableId.table() != null ? tableId.table() : "";
        return this;
    }

    protected SourceInfo update(Instant timestamp, TableId tableId) {
        this.timestamp = timestamp;
        if (tableId != null && tableId.schema() != null) {
            this.schemaName = tableId.schema();
        }
        if (tableId != null && tableId.table() != null) {
            this.tableName = tableId.table();
        }
        return this;
    }

    protected SourceInfo updateLastCommit(Lsn lsn) {
        this.lastCommitLsn = lsn;
        if (lsn != null) {
            this.lsn = lsn;
        }
        return this;
    }

    public Lsn lsn() {
        return this.lsn;
    }

    public Long xmin() {
        return this.xmin;
    }

    public ReplicationMessage.Operation messageType() {
        return this.messageType;
    }

    public String sequence() {
        ArrayList<String> sequence = new ArrayList<String>(2);
        String lastCommitLsn = this.lastCommitLsn != null ? Long.toString(this.lastCommitLsn.asLong()) : null;
        String lsn = this.lsn != null ? Long.toString(this.lsn.asLong()) : null;
        sequence.add(lastCommitLsn);
        sequence.add(lsn);
        try {
            return MAPPER.writeValueAsString(sequence);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String database() {
        return this.dbName;
    }

    String schemaName() {
        return this.schemaName;
    }

    String tableName() {
        return this.tableName;
    }

    protected Instant timestamp() {
        return this.timestamp;
    }

    protected Long txId() {
        return this.txId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("source_info[");
        sb.append("server='").append(this.serverName()).append('\'');
        sb.append("db='").append(this.dbName).append('\'');
        if (this.lsn != null) {
            sb.append(", lsn=").append(this.lsn);
        }
        if (this.txId != null) {
            sb.append(", txId=").append(this.txId);
        }
        if (this.xmin != null) {
            sb.append(", xmin=").append(this.xmin);
        }
        if (this.messageType != null) {
            sb.append(", messageType=").append((Object)this.messageType);
        }
        if (this.lastCommitLsn != null) {
            sb.append(", lastCommitLsn=").append(this.lastCommitLsn);
        }
        if (this.timestamp != null) {
            sb.append(", timestamp=").append(this.timestamp);
        }
        sb.append(", snapshot=").append(this.snapshotRecord);
        if (this.schemaName != null) {
            sb.append(", schema=").append(this.schemaName);
        }
        if (this.tableName != null) {
            sb.append(", table=").append(this.tableName);
        }
        sb.append(']');
        return sb.toString();
    }
}

