/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.transforms.timescaledb;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.postgresql.Module;
import io.debezium.connector.postgresql.transforms.timescaledb.QueryInformationSchemaMetadata;
import io.debezium.connector.postgresql.transforms.timescaledb.TimescaleDbConfigDefinition;
import io.debezium.connector.postgresql.transforms.timescaledb.TimescaleDbMetadata;
import io.debezium.relational.TableId;
import io.debezium.transforms.SmtManager;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimescaleDb<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimescaleDb.class);
    public static final String HEADER_CHUNK_TABLE = "__debezium_timescaledb_chunk_table";
    public static final String HEADER_CHUNK_SCHEMA = "__debezium_timescaledb_chunk_schema";
    public static final String HEADER_HYPERTABLE_TABLE = "__debezium_timescaledb_hypertable_table";
    public static final String HEADER_HYPERTABLE_SCHEMA = "__debezium_timescaledb_hypertable_schema";
    private SmtManager<R> smtManager;
    private TimescaleDbMetadata metadata;
    private String topicPrefix;

    public void configure(Map<String, ?> configs) {
        Configuration config = Configuration.from(configs);
        this.smtManager = new SmtManager(config);
        if (this.metadata == null) {
            this.metadata = new QueryInformationSchemaMetadata(config);
        }
        this.topicPrefix = config.getString(TimescaleDbConfigDefinition.TARGET_TOPIC_PREFIX_FIELD) + ".";
    }

    public R apply(R record) {
        if (!this.smtManager.isValidEnvelope(record)) {
            return record;
        }
        Struct source = ((Struct)record.value()).getStruct("source");
        if (source == null) {
            LOGGER.debug("Incoming record has an empty source info block {}", record);
            return record;
        }
        String schemaName = source.getString("schema");
        String tableName = source.getString("table");
        if (schemaName == null || tableName == null) {
            LOGGER.debug("Incoming record has an empty schema '{}' or table '{}' name", (Object)schemaName, (Object)tableName);
            return record;
        }
        if (!this.metadata.isTimescaleDbSchema(schemaName)) {
            LOGGER.trace("Record for schema '{}' is not intended for TimescaleDB processing", (Object)schemaName);
            return record;
        }
        TableId chunkId = new TableId(null, schemaName, tableName);
        Optional<TableId> hypertableId = this.metadata.hypertableId(chunkId);
        if (hypertableId.isEmpty()) {
            LOGGER.warn("Unable to find hypertable for chunk '{}'", (Object)chunkId);
            return record;
        }
        Optional<TableId> aggregateId = this.metadata.aggregateId(hypertableId.get());
        if (aggregateId.isPresent()) {
            LOGGER.trace("Changing metadata for aggregate from '{}' to '{}'", (Object)chunkId, aggregateId);
        } else {
            LOGGER.trace("Changing metadata for hypertable from '{}' to '{}'", (Object)chunkId, aggregateId);
        }
        TableId newId = aggregateId.orElse(hypertableId.get());
        source.put("schema", (Object)newId.schema());
        source.put("table", (Object)newId.table());
        return (R)record.newRecord(this.getNewTopicName(newId), record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), record.value(), record.timestamp(), (Iterable)this.addHeaders(record.headers(), chunkId, hypertableId.get(), aggregateId));
    }

    private String getNewTopicName(TableId newId) {
        return this.topicPrefix + newId.schema() + "." + newId.table();
    }

    private Headers addHeaders(Headers headers, TableId chunkId, TableId hypertableId, Optional<TableId> aggregateId) {
        headers.addString(HEADER_CHUNK_TABLE, chunkId.table());
        headers.addString(HEADER_CHUNK_SCHEMA, chunkId.schema());
        if (aggregateId.isPresent()) {
            headers.addString(HEADER_HYPERTABLE_TABLE, hypertableId.table());
            headers.addString(HEADER_HYPERTABLE_SCHEMA, hypertableId.schema());
        }
        return headers;
    }

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group((ConfigDef)config, null, (Field[])new Field[]{TimescaleDbConfigDefinition.SCHEMA_LIST_NAMES_FIELD, TimescaleDbConfigDefinition.TARGET_TOPIC_PREFIX_FIELD});
        return config;
    }

    public void close() {
        try {
            this.metadata.close();
        }
        catch (IOException e) {
            LOGGER.warn("Exception while closing the metadata manager", (Throwable)e);
        }
    }

    public String version() {
        return Module.version();
    }

    void setMetadata(TimescaleDbMetadata metadata) {
        this.metadata = metadata;
    }
}

