/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.annotation.Immutable;
import io.debezium.connector.vitess.VitessConnectorConfig;
import io.debezium.relational.Selectors;
import io.debezium.relational.Tables;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

@Immutable
public class Filters {
    protected static final List<String> SYSTEM_SCHEMAS = Arrays.asList("mysql", "performance_schema", "sys", "information_schema");
    protected static final String SYSTEM_SCHEMA_EXCLUDE_LIST = String.join((CharSequence)",", SYSTEM_SCHEMAS);
    private final Tables.TableFilter tableFilter;

    public Filters(VitessConnectorConfig config) {
        this.tableFilter = Tables.TableFilter.fromPredicate((Predicate)Selectors.tableSelector().includeTables(config.tableIncludeList()).excludeTables(config.tableExcludeList()).excludeSchemas(SYSTEM_SCHEMA_EXCLUDE_LIST).build());
    }

    protected Tables.TableFilter tableFilter() {
        return this.tableFilter;
    }
}

