/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.connector.vitess.Filters;
import io.debezium.connector.vitess.VitessConnectorConfig;
import io.debezium.connector.vitess.VitessValueConverter;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.time.ZoneOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitessDatabaseSchema
extends RelationalDatabaseSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitessDatabaseSchema.class);

    public VitessDatabaseSchema(VitessConnectorConfig config, SchemaNameAdjuster schemaNameAdjuster, TopicSelector<TableId> topicSelector) {
        super((RelationalDatabaseConnectorConfig)config, topicSelector, new Filters(config).tableFilter(), config.getColumnFilter(), new TableSchemaBuilder((ValueConverterProvider)new VitessValueConverter(config.getDecimalMode(), config.getTemporalPrecisionMode(), ZoneOffset.UTC, config.binaryHandlingMode(), config.includeUnknownDatatypes()), schemaNameAdjuster, config.customConverterRegistry(), config.getSourceInfoStructMaker().schema(), config.getSanitizeFieldNames(), false), false, config.getKeyMapper());
    }

    public void applySchemaChangesForTable(Table table) {
        if (this.isFilteredOut(table.id())) {
            LOGGER.trace("Skipping schema refresh for table '{}' as table is filtered", (Object)table.id());
            return;
        }
        this.refresh(table);
    }

    private boolean isFilteredOut(TableId id) {
        return !this.getTableFilter().isIncluded(id);
    }

    public void refresh(Table table) {
        this.tables().overwriteTable(table);
        this.refreshSchema(table.id());
    }

    public void refreshSchema(TableId id) {
        LOGGER.trace("refreshing DB schema for table '{}'", (Object)id);
        Table table = this.tableFor(id);
        this.buildAndRegisterSchema(table);
    }

    public static TableId parse(String table) {
        return TableId.parse((String)table, (boolean)false);
    }
}

