/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.relational.TableIdParser;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class TableIdParserTest {
    @Test
    public void canParseValidIdentifiers() {
        Assertions.assertThat((List)TableIdParser.parse((String)"s.a")).containsExactly(new Object[]{"s", "a"});
        Assertions.assertThat((List)TableIdParser.parse((String)"s2.a")).containsExactly(new Object[]{"s2", "a"});
        Assertions.assertThat((List)TableIdParser.parse((String)"table")).containsExactly(new Object[]{"table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"  table  ")).containsExactly(new Object[]{"table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"schema.table")).containsExactly(new Object[]{"schema", "table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"  schema  .  table  ")).containsExactly(new Object[]{"schema", "table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"catalog.schema.table")).containsExactly(new Object[]{"catalog", "schema", "table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"catalog  .  schema  .  table")).containsExactly(new Object[]{"catalog", "schema", "table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"table\"")).containsExactly(new Object[]{"table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"ta.ble\"")).containsExactly(new Object[]{"ta.ble"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"ta   ble\"")).containsExactly(new Object[]{"ta   ble"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"schema\".\"table\"")).containsExactly(new Object[]{"schema", "table"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"cata . log\" . \"sche . ma\" . \"ta . ble\"")).containsExactly(new Object[]{"cata . log", "sche . ma", "ta . ble"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"tab\"\"le\"")).containsExactly(new Object[]{"tab\"le"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"tab\"\"\"\"le\"")).containsExactly(new Object[]{"tab\"\"le"});
        Assertions.assertThat((List)TableIdParser.parse((String)"\"\"\"s\"\"\".\"\"\"a\"\"\"")).containsExactly(new Object[]{"\"s\"", "\"a\""});
    }

    @Test(expected=IllegalArgumentException.class)
    public void leadingSeparatorIsInvalid() {
        TableIdParser.parse((String)".table");
    }

    @Test(expected=IllegalArgumentException.class)
    public void trailingSeparatorIsInvalid() {
        TableIdParser.parse((String)"table.");
    }

    @Test(expected=IllegalArgumentException.class)
    public void unclosedQuotingCharIsInvalid() {
        TableIdParser.parse((String)"\"table");
    }

    @Test(expected=IllegalArgumentException.class)
    public void escapedQuoteDoesntCloseQuotedIdentifier() {
        TableIdParser.parse((String)"\"table\"\"");
    }
}

