/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters.recordandmetadata;

import io.debezium.converters.recordandmetadata.RecordAndMetadata;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class RecordAndMetadataBaseImpl
implements RecordAndMetadata {
    private final Struct record;
    protected final Schema dataSchema;

    public RecordAndMetadataBaseImpl(Struct record, Schema dataSchema) {
        this.record = record;
        this.dataSchema = dataSchema;
    }

    @Override
    public Struct record() {
        return this.record;
    }

    @Override
    public String id() {
        return null;
    }

    @Override
    public String type() {
        return null;
    }

    @Override
    public Struct source() {
        return this.record.getStruct("source");
    }

    @Override
    public String operation() {
        return this.record.getString("op");
    }

    @Override
    public Struct transaction() {
        return this.record.schema().field("transaction") != null ? this.record.getStruct("transaction") : null;
    }

    @Override
    public SchemaAndValue timestamp() {
        String ts_ms = this.record.getInt64("ts_ms").toString();
        Schema ts_msSchema = this.dataSchema.field("ts_ms").schema();
        return new SchemaAndValue(ts_msSchema, (Object)ts_ms);
    }

    @Override
    public Schema dataSchema(String ... dataFields) {
        String connectorType = this.source().getString("connector");
        String dataSchemaName = "io.debezium.connector." + connectorType + ".Data";
        SchemaBuilder builder = SchemaBuilder.struct().name(dataSchemaName);
        if (dataFields.length == 0) {
            for (Field field : this.dataSchema.fields()) {
                builder.field(field.name(), field.schema());
            }
        } else {
            for (String field : dataFields) {
                builder.field(field, this.dataSchema.field(field).schema());
            }
        }
        return builder.build();
    }
}

