/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import io.debezium.schema.SchemaFactory;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public final class Envelope {
    public static final int SCHEMA_VERSION = 1;
    public static final boolean OPERATION_REQUIRED = true;
    public static final Set<String> ALL_FIELD_NAMES;
    public static String SCHEMA_NAME_SUFFIX;
    private final Schema schema;

    public static Builder defineSchema() {
        return SchemaFactory.get().datatypeEnvelopeSchema();
    }

    public static Envelope fromSchema(Schema schema) {
        return new Envelope(schema);
    }

    public Envelope(Schema schema) {
        this.schema = schema;
    }

    public Schema schema() {
        return this.schema;
    }

    public Struct read(Object record, Struct source, Instant timestamp) {
        Struct struct = new Struct(this.schema);
        struct.put("op", (Object)Operation.READ.code());
        struct.put("after", record);
        if (source != null) {
            struct.put("source", (Object)source);
        }
        if (timestamp != null) {
            struct.put("ts_ms", (Object)timestamp.toEpochMilli());
        }
        return struct;
    }

    public Struct create(Object record, Struct source, Instant timestamp) {
        Struct struct = new Struct(this.schema);
        struct.put("op", (Object)Operation.CREATE.code());
        struct.put("after", record);
        if (source != null) {
            struct.put("source", (Object)source);
        }
        if (timestamp != null) {
            struct.put("ts_ms", (Object)timestamp.toEpochMilli());
        }
        return struct;
    }

    public Struct update(Object before, Struct after, Struct source, Instant timestamp) {
        Struct struct = new Struct(this.schema);
        struct.put("op", (Object)Operation.UPDATE.code());
        if (before != null) {
            struct.put("before", before);
        }
        struct.put("after", (Object)after);
        if (source != null) {
            struct.put("source", (Object)source);
        }
        if (timestamp != null) {
            struct.put("ts_ms", (Object)timestamp.toEpochMilli());
        }
        return struct;
    }

    public Struct delete(Object before, Struct source, Instant timestamp) {
        Struct struct = new Struct(this.schema);
        struct.put("op", (Object)Operation.DELETE.code());
        if (before != null) {
            struct.put("before", before);
        }
        if (source != null) {
            struct.put("source", (Object)source);
        }
        if (timestamp != null) {
            struct.put("ts_ms", (Object)timestamp.toEpochMilli());
        }
        return struct;
    }

    public Struct truncate(Struct source, Instant timestamp) {
        Struct struct = new Struct(this.schema);
        struct.put("op", (Object)Operation.TRUNCATE.code());
        struct.put("source", (Object)source);
        struct.put("ts_ms", (Object)timestamp.toEpochMilli());
        return struct;
    }

    public static Operation operationFor(SourceRecord record) {
        Struct value = (Struct)record.value();
        Field opField = value.schema().field("op");
        if (opField != null) {
            return Operation.forCode(value.getString(opField.name()));
        }
        return null;
    }

    public static String schemaName(String type) {
        return type + SCHEMA_NAME_SUFFIX;
    }

    public static boolean isEnvelopeSchema(String schemaName) {
        return schemaName.endsWith(SCHEMA_NAME_SUFFIX);
    }

    public static boolean isEnvelopeSchema(Schema schema) {
        return Envelope.isEnvelopeSchema(schema.name());
    }

    static {
        HashSet<String> fields = new HashSet<String>();
        fields.add("op");
        fields.add("ts_ms");
        fields.add("before");
        fields.add("after");
        fields.add("source");
        fields.add("transaction");
        ALL_FIELD_NAMES = Collections.unmodifiableSet(fields);
        SCHEMA_NAME_SUFFIX = ".Envelope";
    }

    public static interface Builder {
        default public Builder withRecord(Schema schema) {
            return this.withSchema(schema, "before", "after");
        }

        default public Builder withSource(Schema sourceSchema) {
            return this.withSchema(sourceSchema, "source");
        }

        public Builder withSchema(Schema var1, String ... var2);

        public Builder withName(String var1);

        public Builder withDoc(String var1);

        public Envelope build();
    }

    public static final class FieldName {
        public static final String BEFORE = "before";
        public static final String AFTER = "after";
        public static final String OPERATION = "op";
        public static final String SOURCE = "source";
        public static final String TRANSACTION = "transaction";
        public static final String TIMESTAMP = "ts_ms";
    }

    public static enum Operation {
        READ("r"),
        CREATE("c"),
        UPDATE("u"),
        DELETE("d"),
        TRUNCATE("t"),
        MESSAGE("m");

        private final String code;

        private Operation(String code) {
            this.code = code;
        }

        public static Operation forCode(String code) {
            for (Operation op : Operation.values()) {
                if (!op.code().equalsIgnoreCase(code)) continue;
                return op;
            }
            return null;
        }

        public String code() {
            return this.code;
        }
    }
}

