/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.metrics.Metrics;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.SchemaHistoryListener;
import io.debezium.relational.history.SchemaHistoryMXBean;
import io.debezium.util.Clock;
import io.debezium.util.ElapsedTimeStrategy;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaHistoryMetrics
extends Metrics
implements SchemaHistoryListener,
SchemaHistoryMXBean {
    private static final String CONTEXT_NAME = "schema-history";
    private static final Duration PAUSE_BETWEEN_LOG_MESSAGES = Duration.ofSeconds(2L);
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaHistoryMetrics.class);
    private SchemaHistoryStatus status = SchemaHistoryStatus.STOPPED;
    private Instant recoveryStartTime = null;
    private AtomicLong changesRecovered = new AtomicLong();
    private AtomicLong totalChangesApplied = new AtomicLong();
    private Instant lastChangeAppliedTimestamp;
    private Instant lastChangeRecoveredTimestamp;
    private HistoryRecord lastAppliedChange;
    private HistoryRecord lastRecoveredChange;
    private final Clock clock = Clock.system();
    private final ElapsedTimeStrategy lastChangeAppliedLogDelay = ElapsedTimeStrategy.constant(this.clock, PAUSE_BETWEEN_LOG_MESSAGES);
    private final ElapsedTimeStrategy lastChangeRecoveredLogDelay = ElapsedTimeStrategy.constant(this.clock, PAUSE_BETWEEN_LOG_MESSAGES);

    public SchemaHistoryMetrics(CommonConnectorConfig connectorConfig, boolean multiPartitionMode) {
        super(connectorConfig, CONTEXT_NAME, multiPartitionMode);
        this.lastChangeAppliedLogDelay.hasElapsed();
        this.lastChangeRecoveredLogDelay.hasElapsed();
    }

    @Override
    public String getStatus() {
        return this.status.toString();
    }

    @Override
    public long getRecoveryStartTime() {
        return this.recoveryStartTime == null ? -1L : this.recoveryStartTime.getEpochSecond();
    }

    @Override
    public long getChangesRecovered() {
        return this.changesRecovered.get();
    }

    @Override
    public long getChangesApplied() {
        return this.totalChangesApplied.get();
    }

    @Override
    public long getMilliSecondsSinceLastAppliedChange() {
        return this.lastChangeAppliedTimestamp == null ? -1L : Duration.between(this.lastChangeAppliedTimestamp, Instant.now()).toMillis();
    }

    @Override
    public long getMilliSecondsSinceLastRecoveredChange() {
        return this.lastChangeRecoveredTimestamp == null ? -1L : Duration.between(this.lastChangeRecoveredTimestamp, Instant.now()).toMillis();
    }

    @Override
    public String getLastAppliedChange() {
        return this.lastAppliedChange == null ? "" : this.lastAppliedChange.toString();
    }

    @Override
    public String getLastRecoveredChange() {
        return this.lastRecoveredChange == null ? "" : this.lastRecoveredChange.toString();
    }

    @Override
    public void started() {
        this.status = SchemaHistoryStatus.RUNNING;
        this.register();
    }

    @Override
    public void stopped() {
        this.status = SchemaHistoryStatus.STOPPED;
        this.unregister();
    }

    @Override
    public void recoveryStarted() {
        this.status = SchemaHistoryStatus.RECOVERING;
        this.recoveryStartTime = Instant.now();
        LOGGER.info("Started database schema history recovery");
    }

    @Override
    public void recoveryStopped() {
        this.status = SchemaHistoryStatus.RUNNING;
        LOGGER.info("Finished database schema history recovery of {} change(s) in {} ms", (Object)this.changesRecovered.get(), (Object)Duration.between(this.recoveryStartTime, Instant.now()).toMillis());
    }

    @Override
    public void onChangeFromHistory(HistoryRecord record) {
        this.lastRecoveredChange = record;
        this.changesRecovered.incrementAndGet();
        if (this.lastChangeRecoveredLogDelay.hasElapsed()) {
            LOGGER.info("Database schema history recovery in progress, recovered {} records", (Object)this.changesRecovered);
        }
        this.lastChangeRecoveredTimestamp = Instant.now();
    }

    @Override
    public void onChangeApplied(HistoryRecord record) {
        this.lastAppliedChange = record;
        this.totalChangesApplied.incrementAndGet();
        if (this.lastChangeAppliedLogDelay.hasElapsed()) {
            LOGGER.info("Already applied {} database changes", (Object)this.totalChangesApplied);
        }
        this.lastChangeAppliedTimestamp = Instant.now();
    }

    public static enum SchemaHistoryStatus {
        STOPPED,
        RECOVERING,
        RUNNING;

    }
}

