/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.service;

import io.debezium.DebeziumException;
import io.debezium.annotation.ThreadSafe;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.common.annotation.Incubating;
import io.debezium.config.Configuration;
import io.debezium.service.Service;
import io.debezium.service.ServiceDependencyException;
import io.debezium.service.ServiceRegistration;
import io.debezium.service.UnknownServiceException;
import io.debezium.service.spi.Configurable;
import io.debezium.service.spi.InjectService;
import io.debezium.service.spi.ServiceProvider;
import io.debezium.service.spi.ServiceRegistry;
import io.debezium.service.spi.ServiceRegistryAware;
import io.debezium.service.spi.Startable;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Incubating
public class DefaultServiceRegistry
implements ServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceRegistry.class);
    private final ConcurrentMap<Class<?>, ServiceRegistration<?>> serviceRegistrations = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Service> initializedServices = new ConcurrentHashMap();
    private final List<ServiceRegistration<?>> registrations = new ArrayList();
    private final Configuration configuration;

    public DefaultServiceRegistry(Configuration configuration, BeanRegistry beanRegistry) {
        this.configuration = configuration;
        this.registerService(new ServiceRegistration<BeanRegistry>(BeanRegistry.class, beanRegistry), beanRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Service> T getService(Class<T> serviceClass) {
        Service service = (Service)serviceClass.cast(this.initializedServices.get(serviceClass));
        if (service != null) {
            return (T)service;
        }
        DefaultServiceRegistry defaultServiceRegistry = this;
        synchronized (defaultServiceRegistry) {
            service = (Service)serviceClass.cast(this.initializedServices.get(serviceClass));
            if (service != null) {
                return (T)service;
            }
            ServiceRegistration<T> registration = this.findRegistration(serviceClass);
            if (registration == null) {
                throw new UnknownServiceException(serviceClass);
            }
            service = registration.getService();
            if (service == null) {
                service = this.initializeService(registration);
            }
            if (service != null) {
                this.initializedServices.put(serviceClass, service);
            }
            return (T)service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.initializedServices.clear();
        List<ServiceRegistration<?>> list = this.registrations;
        synchronized (list) {
            ListIterator<ServiceRegistration<?>> iterator = this.registrations.listIterator(this.registrations.size());
            while (iterator.hasPrevious()) {
                ServiceRegistration<?> registration = iterator.previous();
                try {
                    this.stopService(registration);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to stop service " + registration.getServiceClass().getName(), (Throwable)e);
                }
            }
            this.registrations.clear();
        }
        this.serviceRegistrations.clear();
        LOGGER.info("Debezium ServiceRegistry stopped.");
    }

    @Override
    public <T extends Service> void registerServiceProvider(ServiceProvider<T> serviceProvider) {
        ServiceRegistration<T> registration = new ServiceRegistration<T>(serviceProvider);
        this.serviceRegistrations.put(serviceProvider.getServiceClass(), registration);
    }

    private <T extends Service> T createService(ServiceProvider<T> serviceProvider) {
        return serviceProvider.createService(this.configuration, this);
    }

    private <T extends Service> void configureService(ServiceRegistration<T> registration) {
        if (registration.getService() instanceof Configurable) {
            ((Configurable)registration.getService()).configure(this.configuration);
        }
    }

    private <T extends Service> void injectDependencies(ServiceRegistration<T> registration) {
        T service = registration.getService();
        this.doInjections(service);
        if (service instanceof ServiceRegistryAware) {
            ((ServiceRegistryAware)service).injectServiceRegistry(this);
        }
    }

    private <T extends Service> void startService(ServiceRegistration<T> registration) {
        if (registration.getService() instanceof Startable) {
            ((Startable)registration.getService()).start();
        }
    }

    private <T extends Service> void stopService(ServiceRegistration<T> registration) throws IOException {
        if (registration.getService() instanceof Closeable) {
            ((Closeable)registration.getService()).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Service> void registerService(ServiceRegistration<T> registration, T service) {
        registration.setService(service);
        List<ServiceRegistration<?>> list = this.registrations;
        synchronized (list) {
            this.serviceRegistrations.put(registration.getServiceClass(), registration);
            this.registrations.add(registration);
        }
    }

    private <T extends Service> void doInjections(T service) {
        try {
            for (Method method : service.getClass().getMethods()) {
                InjectService injectService = method.getAnnotation(InjectService.class);
                if (injectService == null) continue;
                this.doInjection(service, method, injectService);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to inject services into service: " + service.getClass().getName(), (Throwable)e);
        }
    }

    private <T extends Service> void doInjection(T service, Method method, InjectService injectService) {
        Object requestedService;
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (method.getParameterCount() != 1) {
            throw new ServiceDependencyException("InjectService on a method with an unexpected number of parameters");
        }
        Class<?> requestedServiceType = injectService.service();
        if (requestedServiceType == null || requestedServiceType.equals(Void.class)) {
            requestedServiceType = parameterTypes[0];
        }
        if ((requestedService = this.getService(requestedServiceType)) == null) {
            if (injectService.required()) {
                throw new ServiceDependencyException(String.format("Service '%s' not found, required by '%s'.", requestedServiceType.getName(), service.getClass().getName()));
            }
        } else {
            try {
                method.invoke(service, requestedService);
            }
            catch (Exception e) {
                throw new ServiceDependencyException(String.format("Failed to inject service '%s' into '%s'.", requestedServiceType.getName(), service.getClass().getName()));
            }
        }
    }

    private <T extends Service> ServiceRegistration<T> findRegistration(Class<T> serviceClass) {
        return (ServiceRegistration)this.serviceRegistrations.get(serviceClass);
    }

    private <T extends Service> T initializeService(ServiceRegistration<T> registration) {
        T service = this.createService(registration);
        if (service == null) {
            return null;
        }
        this.doMultiPhaseInitialization(registration);
        return service;
    }

    private <T extends Service> void doMultiPhaseInitialization(ServiceRegistration<T> registration) {
        this.injectDependencies(registration);
        this.configureService(registration);
        this.startService(registration);
    }

    private <T extends Service> T createService(ServiceRegistration<T> registration) {
        ServiceProvider<T> initiator = registration.getServiceProvider();
        if (initiator == null) {
            throw new UnknownServiceException(registration.getServiceClass());
        }
        try {
            T service = this.createService(initiator);
            if (service != null) {
                this.registerService(registration, service);
            }
            return service;
        }
        catch (Exception e) {
            throw new DebeziumException(String.format("Unable to create service %s", registration.getServiceClass().getName()), (Throwable)e);
        }
    }
}

