/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.jdbc;

import io.debezium.config.EnumeratedValue;
import io.debezium.time.Date;
import io.debezium.time.IsoDate;
import io.debezium.time.IsoTime;
import io.debezium.time.IsoTimestamp;
import io.debezium.time.MicroTime;
import io.debezium.time.MicroTimestamp;
import io.debezium.time.NanoTime;
import io.debezium.time.NanoTimestamp;
import io.debezium.time.Time;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Timestamp;

public enum TemporalPrecisionMode implements EnumeratedValue
{
    ADAPTIVE("adaptive", Date::builder, x -> x <= 3 ? Time.builder() : (x <= 6 ? MicroTime.builder() : NanoTime.builder()), x -> x <= 3 ? io.debezium.time.Timestamp.builder() : (x <= 6 ? MicroTimestamp.builder() : NanoTimestamp.builder())),
    ADAPTIVE_TIME_MICROSECONDS("adaptive_time_microseconds", Date::builder, x -> MicroTime.builder(), x -> x <= 3 ? io.debezium.time.Timestamp.builder() : (x <= 6 ? MicroTimestamp.builder() : NanoTimestamp.builder())),
    ISOSTRING("isostring", IsoDate::builder, x -> IsoTime.builder(), x -> IsoTimestamp.builder()),
    CONNECT("connect", org.apache.kafka.connect.data.Date::builder, x -> org.apache.kafka.connect.data.Time.builder(), x -> Timestamp.builder()),
    MICROSECONDS("microseconds", Date::builder, x -> MicroTime.builder(), x -> MicroTimestamp.builder()),
    NANOSECONDS("nanoseconds", Date::builder, x -> NanoTime.builder(), x -> NanoTimestamp.builder());

    private final String value;
    private final Supplier<SchemaBuilder> dateBuilder;
    private final Function<Integer, SchemaBuilder> timeBuilder;
    private final Function<Integer, SchemaBuilder> timestampBuilder;

    private TemporalPrecisionMode(String value, Supplier<SchemaBuilder> dateBuilder, Function<Integer, SchemaBuilder> timeBuilder, Function<Integer, SchemaBuilder> timestampBuilder) {
        this.value = value;
        this.dateBuilder = dateBuilder;
        this.timeBuilder = timeBuilder;
        this.timestampBuilder = timestampBuilder;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static TemporalPrecisionMode parse(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        for (TemporalPrecisionMode option : TemporalPrecisionMode.values()) {
            if (!option.getValue().equalsIgnoreCase(value)) continue;
            return option;
        }
        return null;
    }

    public static TemporalPrecisionMode parse(String value, String defaultValue) {
        TemporalPrecisionMode mode = TemporalPrecisionMode.parse(value);
        if (mode == null && defaultValue != null) {
            mode = TemporalPrecisionMode.parse(defaultValue);
        }
        return mode;
    }

    public SchemaBuilder getDateBuilder() {
        return this.dateBuilder.get();
    }

    public SchemaBuilder getTimeBuilder(int precision) {
        return this.timeBuilder.apply(precision);
    }

    public SchemaBuilder getTimestampBuilder(int precision) {
        return this.timestampBuilder.apply(precision);
    }
}

