/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.openlineage;

import io.debezium.Module;
import io.debezium.config.Configuration;
import io.debezium.connector.common.DebeziumTaskState;
import io.debezium.openlineage.ConnectorContext;
import io.debezium.openlineage.DebeziumOpenLineageEmitter;
import io.debezium.openlineage.dataset.DatasetDataExtractor;
import io.debezium.openlineage.dataset.DatasetMetadata;
import io.debezium.transforms.SmtManager;
import io.debezium.util.BoundedConcurrentHashMap;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLineage<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenLineage.class);
    private static final int CACHE_SIZE = 64;
    private ZonedDateTime lastEmissionTime;
    private final BoundedConcurrentHashMap<String, Boolean> recentlySeenTopics = new BoundedConcurrentHashMap(64);
    private final BoundedConcurrentHashMap<Schema, Boolean> recentlySeenSchemas = new BoundedConcurrentHashMap(64);
    private SmtManager<R> smtManager;
    private DatasetDataExtractor datasetDataExtractor;

    public ConfigDef config() {
        return new ConfigDef();
    }

    public void configure(Map<String, ?> props) {
        Configuration config = Configuration.from(props);
        this.smtManager = new SmtManager(config);
        this.datasetDataExtractor = new DatasetDataExtractor();
    }

    public R apply(R record) {
        if (this.smtManager.isValidRecordForLineage(record)) {
            return record;
        }
        if (this.recentlySeenTopics.put(record.topic(), true) == null || this.recentlySeenSchemas.put(record.valueSchema(), true) == null) {
            if (this.recentlySeenSchemas.put(record.valueSchema(), true) == null) {
                List fieldDefinitions = this.datasetDataExtractor.extract(record);
                ConnectorContext connectorContext = ConnectorContext.from((Headers)record.headers());
                DebeziumOpenLineageEmitter.emit((ConnectorContext)connectorContext, (DebeziumTaskState)DebeziumTaskState.RUNNING, List.of(new DatasetMetadata(record.topic(), DatasetMetadata.DatasetKind.OUTPUT, "STREAM", DatasetMetadata.DataStore.KAFKA, fieldDefinitions)));
                this.lastEmissionTime = ZonedDateTime.now();
            }
            LOGGER.debug("Emitting running event for output dataset {}", (Object)record.topic());
            return record;
        }
        return record;
    }

    public void close() {
    }

    public String version() {
        return Module.version();
    }
}

