/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public class ApproximateStructSizeCalculator {
    private static final int EMPTY_STRUCT_SIZE = 56;
    private static final int EMPTY_STRING_SIZE = 56;
    private static final int EMPTY_BYTES_SIZE = 24;
    private static final int EMPTY_ARRAY_SIZE = 64;
    private static final int EMPTY_MAP_SIZE = 88;
    private static final int EMPTY_PRIMITIVE = 24;
    private static final int REFERENCE_SIZE = 8;

    public static long getApproximateRecordSize(SourceRecord changeEvent) {
        long value = (long)changeEvent.sourcePartition().size() * 100L + (long)changeEvent.sourceOffset().size() * 100L + (long)changeEvent.headers().size() * 100L;
        return (value += 8L) + ApproximateStructSizeCalculator.getStructSize((Struct)changeEvent.key()) + ApproximateStructSizeCalculator.getStructSize((Struct)changeEvent.value()) + (long)changeEvent.topic().getBytes().length;
    }

    private static long getStructSize(Struct struct) {
        if (struct == null) {
            return 0L;
        }
        long size = 56L;
        Schema schema = struct.schema();
        for (Field field : schema.fields()) {
            size += 8L;
            size += ApproximateStructSizeCalculator.getValueSize(field.schema(), struct.getWithoutDefault(field.name()));
        }
        return size;
    }

    private static long getValueSize(Schema schema, Object value) {
        switch (schema.type()) {
            case BOOLEAN: 
            case INT8: 
            case INT16: 
            case FLOAT32: 
            case INT32: 
            case FLOAT64: 
            case INT64: {
                return 24L;
            }
            case STRING: {
                String s = (String)value;
                return s == null ? 0L : (long)(56 + s.getBytes().length);
            }
            case BYTES: {
                byte[] b;
                if (value instanceof BigDecimal) {
                    b = ((BigDecimal)value).unscaledValue().toByteArray();
                } else if (value instanceof ByteBuffer) {
                    ByteBuffer buffer = (ByteBuffer)value;
                    b = ApproximateStructSizeCalculator.toArray(buffer, 0, buffer.remaining());
                } else {
                    b = (byte[])value;
                }
                return b == null ? 0L : (long)(24 + b.length);
            }
            case STRUCT: {
                return ApproximateStructSizeCalculator.getStructSize((Struct)value);
            }
            case ARRAY: {
                return ApproximateStructSizeCalculator.getArraySize(schema.valueSchema(), (List)value);
            }
            case MAP: {
                return ApproximateStructSizeCalculator.getMapSize(schema.keySchema(), schema.valueSchema(), (Map)value);
            }
        }
        return 0L;
    }

    private static long getArraySize(Schema elementSchema, List<Object> array) {
        if (array == null) {
            return 0L;
        }
        long size = 64L;
        for (Object element : array) {
            size += 8L;
            size += ApproximateStructSizeCalculator.getValueSize(elementSchema, element);
        }
        return size;
    }

    private static long getMapSize(Schema keySchema, Schema valueSchema, Map<Object, Object> map) {
        if (map == null) {
            return 0L;
        }
        long size = 88L;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            size += 16L;
            size += ApproximateStructSizeCalculator.getValueSize(keySchema, entry.getKey());
            size += ApproximateStructSizeCalculator.getValueSize(valueSchema, entry.getValue());
        }
        return size;
    }

    private static byte[] toArray(ByteBuffer buffer, int offset, int size) {
        byte[] dest = new byte[size];
        if (buffer.hasArray()) {
            System.arraycopy(buffer.array(), buffer.position() + buffer.arrayOffset() + offset, dest, 0, size);
        } else {
            int pos = buffer.position();
            buffer.position(pos + offset);
            buffer.get(dest);
            buffer.position(pos);
        }
        return dest;
    }
}

