/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.spi;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.SnapshotType;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.spi.schema.DataCollectionId;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public interface OffsetContext {
    public Map<String, ?> getOffset();

    public Schema getSourceInfoSchema();

    public Struct getSourceInfo();

    public boolean isInitialSnapshotRunning();

    public void markSnapshotRecord(SnapshotRecord var1);

    public void preSnapshotStart(boolean var1);

    public void preSnapshotCompletion();

    public void postSnapshotCompletion();

    public void event(DataCollectionId var1, Instant var2);

    public TransactionContext getTransactionContext();

    default public void incrementalSnapshotEvents() {
    }

    default public IncrementalSnapshotContext<?> getIncrementalSnapshotContext() {
        return null;
    }

    public static interface Loader<O extends OffsetContext> {
        default public Optional<SnapshotType> loadSnapshot(Map<String, ?> offset) {
            Object snapshot = offset.getOrDefault("snapshot", null);
            if (Boolean.TRUE.equals(snapshot) || Boolean.TRUE.toString().equals(snapshot)) {
                return Optional.of(SnapshotType.INITIAL);
            }
            return snapshot == null ? Optional.empty() : Optional.of(SnapshotType.valueOf(snapshot));
        }

        default public boolean loadSnapshotCompleted(Map<String, ?> offset) {
            return Boolean.TRUE.equals(offset.get("snapshot_completed")) || "true".equals(offset.get("snapshot_completed"));
        }

        public O load(Map<String, ?> var1);
    }
}

