/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.bindings.kafka;

import io.debezium.DebeziumException;
import io.debezium.annotation.Immutable;
import io.debezium.bindings.kafka.DebeziumSinkRecord;
import io.debezium.data.Envelope;
import io.debezium.sink.SinkConnectorConfig;
import io.debezium.sink.field.FieldDescriptor;
import io.debezium.sink.filter.FieldFilterFactory;
import io.debezium.util.Strings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Values;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;

@Immutable
public class KafkaDebeziumSinkRecord
implements DebeziumSinkRecord {
    protected final String cloudEventsSchemaNamePattern;
    protected final SinkRecord originalKafkaRecord;
    private final Struct kafkaCoordinates;
    private final Struct kafkaPayload;
    private final Struct kafkaHeader;
    private Boolean isDebeziumMessage = null;
    private Boolean isFlattened = null;
    private Boolean isDelete = null;
    private Optional<Object> cachedValue = null;
    private final Map<String, FieldDescriptor> kafkaFields = new LinkedHashMap<String, FieldDescriptor>();
    protected final Map<String, FieldDescriptor> allFields = new LinkedHashMap<String, FieldDescriptor>();
    private static final String KAFKA_COORDINATES = "__kafka_coordinates";
    private static final String CONNECT_TOPIC = "__connect_topic";
    private static final String CONNECT_PARTITION = "__connect_partition";
    private static final String CONNECT_OFFSET = "__connect_offset";
    public static final Schema KAFKA_COORDINATES_SCHEMA = SchemaBuilder.struct().name("__kafka_coordinates").field("__connect_topic", Schema.OPTIONAL_STRING_SCHEMA).field("__connect_partition", Schema.OPTIONAL_INT32_SCHEMA).field("__connect_offset", Schema.OPTIONAL_INT64_SCHEMA).build();
    private static final String KAFKA_HEADERS_SUFFIX = "$__kafka_headers";

    public KafkaDebeziumSinkRecord(SinkRecord record, String cloudEventsSchemaNamePattern) {
        boolean flattened;
        Objects.requireNonNull(record, "The sink record must be provided.");
        this.cloudEventsSchemaNamePattern = null == cloudEventsSchemaNamePattern ? "CloudEvents.Envelope" : cloudEventsSchemaNamePattern;
        this.originalKafkaRecord = record;
        this.kafkaCoordinates = this.getKafkaCoordinates();
        this.kafkaHeader = this.getRecordHeaders();
        this.kafkaPayload = this.isDelete() ? this.getKafkaPayload(!this.isDebeziumMessage()) : ((flattened = this.isFlattened()) || !this.isTruncate() ? this.getKafkaPayload(flattened) : null);
    }

    @Override
    public String topicName() {
        return this.originalKafkaRecord.topic();
    }

    @Override
    public Integer partition() {
        return this.originalKafkaRecord.kafkaPartition();
    }

    @Override
    public long offset() {
        return this.originalKafkaRecord.kafkaOffset();
    }

    @Override
    public Struct kafkaCoordinates() {
        return this.kafkaCoordinates;
    }

    @Override
    public Struct kafkaHeader() {
        return this.kafkaHeader;
    }

    @Override
    public Map<String, FieldDescriptor> allFields() {
        return this.allFields;
    }

    @Override
    public Object key() {
        return this.originalKafkaRecord.key();
    }

    @Override
    public Schema keySchema() {
        return this.originalKafkaRecord.keySchema();
    }

    private static Struct buildStructFromMap(Map<?, ?> map, Schema schema) {
        Struct struct = new Struct(schema);
        schema.fields().forEach(field -> {
            switch (field.schema().type()) {
                case STRUCT: {
                    struct.put(field.name(), (Object)KafkaDebeziumSinkRecord.buildStructFromMap((Map)map.get(field.name()), field.schema()));
                    break;
                }
                default: {
                    struct.put(field.name(), map.get(field.name()));
                }
            }
        });
        return struct;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object value() {
        if (null != this.cachedValue) return this.cachedValue.get();
        if (this.valueSchema() != null && this.valueSchema().name() != null && this.valueSchema().name().matches(this.cloudEventsSchemaNamePattern)) {
            Object originalKafkaValue = this.originalKafkaRecord.value();
            if (originalKafkaValue instanceof Struct) {
                Struct kafkaStruct = (Struct)originalKafkaValue;
                this.cachedValue = Optional.ofNullable(kafkaStruct.getStruct("data"));
                return this.cachedValue.get();
            } else {
                if (!(originalKafkaValue instanceof Map)) throw new ConnectException("Unexpected value type: " + String.valueOf(originalKafkaValue.getClass()));
                Map m = (Map)originalKafkaValue;
                SchemaBuilder schemaBuilder = SchemaBuilder.struct();
                if (Schema.Type.STRUCT.equals((Object)this.valueSchema().type())) {
                    schemaBuilder.name(this.valueSchema().field("data").schema().name());
                }
                Map mapData = (Map)m.get("data");
                mapData.forEach((k, v) -> {
                    if (null == v) {
                        schemaBuilder.field(k, Schema.OPTIONAL_STRING_SCHEMA);
                    } else if (v instanceof Map) {
                        Map m2 = (Map)v;
                        schemaBuilder.field(k, KafkaValues.inferSchemaFromMap(m2));
                    } else {
                        schemaBuilder.field(k, Values.inferSchema((Object)v));
                    }
                });
                Schema schema = schemaBuilder.build();
                this.cachedValue = Optional.of(KafkaDebeziumSinkRecord.buildStructFromMap(mapData, schema));
            }
            return this.cachedValue.get();
        } else {
            this.cachedValue = null == this.originalKafkaRecord.value() ? Optional.of(new Struct(this.originalKafkaRecord.valueSchema())) : Optional.ofNullable(this.originalKafkaRecord.value());
        }
        return this.cachedValue.get();
    }

    @Override
    public Schema valueSchema() {
        return this.originalKafkaRecord.valueSchema();
    }

    @Override
    public boolean isDebeziumMessage() {
        if (null == this.isDebeziumMessage) {
            Schema kafkaValueSchema;
            this.isDebeziumMessage = this.originalKafkaRecord.value() != null && this.originalKafkaRecord.valueSchema() != null ? Boolean.valueOf((kafkaValueSchema = ((Struct)this.value()).schema()).name() != null && Envelope.isEnvelopeSchema((String)kafkaValueSchema.name()) || null == kafkaValueSchema.name() && null != kafkaValueSchema.field("op")) : Boolean.valueOf(false);
        }
        return this.isDebeziumMessage;
    }

    @Override
    public boolean isSchemaChange() {
        return this.originalKafkaRecord.valueSchema() != null && !Strings.isNullOrEmpty((String)this.originalKafkaRecord.valueSchema().name()) && this.originalKafkaRecord.valueSchema().name().contains("SchemaChangeValue");
    }

    public boolean isFlattened() {
        if (null == this.isFlattened) {
            Struct value;
            this.isFlattened = !this.isTombstone() && null != this.originalKafkaRecord.valueSchema() ? (null == (value = (Struct)this.value()) ? Boolean.valueOf(true) : Boolean.valueOf(value.schema() == null || !this.isDebeziumMessage())) : Boolean.valueOf(false);
        }
        return this.isFlattened;
    }

    @Override
    public boolean isTombstone() {
        return this.originalKafkaRecord.value() == null && this.originalKafkaRecord.valueSchema() == null;
    }

    @Override
    public boolean isDelete() {
        if (null == this.isDelete) {
            if (!this.isDebeziumMessage()) {
                this.isDelete = null == this.originalKafkaRecord.value();
            } else if (this.originalKafkaRecord.value() != null) {
                Struct value = (Struct)this.value();
                this.isDelete = Envelope.Operation.DELETE.equals((Object)Envelope.Operation.forCode((String)value.getString("op")));
            } else {
                this.isDelete = false;
            }
        }
        return this.isDelete;
    }

    @Override
    public boolean isTruncate() {
        if (this.isDebeziumMessage()) {
            return Envelope.Operation.TRUNCATE.equals((Object)Envelope.Operation.forCode((String)((Struct)this.value()).getString("op")));
        }
        return false;
    }

    @Override
    public Struct getPayload() {
        return this.kafkaPayload;
    }

    @Override
    public Struct getFilteredPayload(FieldFilterFactory.FieldNameFilter fieldsFilter) {
        return this.filterFields(this.getPayload(), this.topicName(), Set.of(), fieldsFilter);
    }

    private Struct filterFields(Struct data, String topicName, Set<String> allowedPrimaryKeyFields, FieldFilterFactory.FieldNameFilter fieldsFilter) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        if (!allowedPrimaryKeyFields.isEmpty()) {
            data.schema().fields().stream().filter(field -> allowedPrimaryKeyFields.contains(field.name())).forEach(field -> schemaBuilder.field(field.name(), field.schema()));
            Schema schema = schemaBuilder.build();
            Struct filteredData = new Struct(schema);
            schema.fields().forEach(field -> filteredData.put(field.name(), data.get(field.name())));
            return filteredData;
        }
        data.schema().fields().forEach(field -> {
            if (null != fieldsFilter) {
                if (fieldsFilter.matches(topicName, field.name())) {
                    schemaBuilder.field(field.name(), field.schema());
                }
            } else {
                schemaBuilder.field(field.name(), field.schema());
            }
        });
        Schema schema = schemaBuilder.build();
        Struct filteredData = new Struct(schema);
        schema.fields().forEach(field -> {
            Object fieldValue = data.get(field.name());
            if (null != fieldValue && (null == fieldsFilter || fieldsFilter.matches(topicName, field.name()))) {
                filteredData.put(field.name(), fieldValue);
            }
        });
        return filteredData;
    }

    @Override
    public Struct getFilteredKey(SinkConnectorConfig.PrimaryKeyMode primaryKeyMode, Set<String> allowedPrimaryKeyFields, FieldFilterFactory.FieldNameFilter fieldsFilter) {
        switch (primaryKeyMode) {
            case NONE: {
                return null;
            }
            case RECORD_KEY: {
                Schema keySchema = this.keySchema();
                if (keySchema == null) {
                    throw new ConnectException("Configured primary key mode 'record_key' cannot have null schema");
                }
                if (keySchema.type().isPrimitive()) {
                    return this.keyAsStruct();
                }
                if (Schema.Type.STRUCT.equals((Object)keySchema.type())) {
                    return this.filterFields(this.keyAsStruct(), this.topicName(), allowedPrimaryKeyFields, fieldsFilter);
                }
                throw new ConnectException("An unsupported record key schema type detected: " + String.valueOf(keySchema.type()));
            }
            case RECORD_VALUE: {
                Struct payload = this.getPayload();
                Schema valueSchema = payload.schema();
                if (valueSchema != null && Schema.Type.STRUCT.equals((Object)valueSchema.type())) {
                    return this.filterFields(payload, this.topicName(), allowedPrimaryKeyFields, fieldsFilter);
                }
                throw new ConnectException("No struct-based primary key defined for record value");
            }
            case RECORD_HEADER: {
                if (this.originalKafkaRecord.headers().isEmpty()) {
                    throw new ConnectException("Configured primary key mode 'record_header' cannot have empty message headers");
                }
                return this.getRecordHeaders();
            }
            case KAFKA: {
                return this.kafkaCoordinates();
            }
        }
        throw new DebeziumException("Unknown primary key mode: " + String.valueOf((Object)primaryKeyMode));
    }

    public SinkRecord getOriginalKafkaRecord() {
        return this.originalKafkaRecord;
    }

    private Struct getKafkaCoordinates() {
        Struct kafkaCoordinatesStruct = new Struct(KAFKA_COORDINATES_SCHEMA);
        kafkaCoordinatesStruct.put(CONNECT_TOPIC, (Object)this.originalKafkaRecord.topic()).put(CONNECT_PARTITION, (Object)this.originalKafkaRecord.kafkaPartition()).put(CONNECT_OFFSET, (Object)this.originalKafkaRecord.kafkaOffset());
        this.kafkaFields.put(CONNECT_TOPIC, new FieldDescriptor(Schema.STRING_SCHEMA, CONNECT_TOPIC, true));
        this.kafkaFields.put(CONNECT_PARTITION, new FieldDescriptor(Schema.INT32_SCHEMA, CONNECT_PARTITION, true));
        this.kafkaFields.put(CONNECT_OFFSET, new FieldDescriptor(Schema.INT64_SCHEMA, CONNECT_OFFSET, true));
        return kafkaCoordinatesStruct;
    }

    @Override
    public Map<String, FieldDescriptor> kafkaFields() {
        if (this.kafkaFields.isEmpty()) {
            this.getKafkaCoordinates();
        }
        return this.kafkaFields;
    }

    private Struct keyAsStruct() {
        if (this.keySchema() != null) {
            return (Struct)this.originalKafkaRecord.key();
        }
        return null;
    }

    private Struct getRecordHeaders() {
        SchemaBuilder headerSchemaBuilder = SchemaBuilder.struct().name(this.originalKafkaRecord.topic() + KAFKA_HEADERS_SUFFIX);
        this.originalKafkaRecord.headers().forEach(header -> headerSchemaBuilder.field(header.key(), header.schema()));
        Schema headerSchema = headerSchemaBuilder.build();
        Struct headerStruct = new Struct(headerSchema);
        this.originalKafkaRecord.headers().forEach(header -> headerStruct.put(header.key(), header.value()));
        return headerStruct;
    }

    private Struct getKafkaPayload(boolean flattened) {
        Schema valueSchema = this.valueSchema();
        if (valueSchema == null) {
            return null;
        }
        Struct rawPayload = (Struct)this.value();
        if (flattened) {
            return Objects.requireNonNullElseGet(rawPayload, () -> new Struct(rawPayload.schema()));
        }
        if (this.isDelete()) {
            return rawPayload.getStruct("before");
        }
        return rawPayload.getStruct("after");
    }

    private static class KafkaValues
    extends Values {
        private KafkaValues() {
        }

        public static Schema inferSchemaFromMap(Map<?, ?> map) {
            if (map.isEmpty()) {
                return null;
            }
            boolean isMap = true;
            Values.SchemaDetector keyDetector = new Values.SchemaDetector();
            Values.SchemaDetector valueDetector = new Values.SchemaDetector();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (keyDetector.canDetect(entry.getKey()) && valueDetector.canDetect(entry.getValue())) continue;
                isMap = false;
                break;
            }
            if (isMap) {
                return SchemaBuilder.map((Schema)keyDetector.schema(), (Schema)valueDetector.schema()).build();
            }
            SchemaBuilder schemaBuilder = SchemaBuilder.struct();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Values.SchemaDetector newValueDetector = new Values.SchemaDetector();
                if (null == entry.getValue()) {
                    schemaBuilder.field(entry.getKey().toString(), Schema.OPTIONAL_STRING_SCHEMA);
                    continue;
                }
                if (!newValueDetector.canDetect(entry.getValue())) continue;
                schemaBuilder.field(entry.getKey().toString(), newValueDetector.schema());
            }
            return schemaBuilder.build();
        }
    }
}

