/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.sink.field;

import io.debezium.annotation.Immutable;
import io.debezium.util.SchemaUtils;
import org.apache.kafka.connect.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class FieldDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldDescriptor.class);
    protected final Schema schema;
    protected final String name;
    protected final boolean isKey;
    protected final String columnName;

    public FieldDescriptor(Schema schema, String name, boolean isKey) {
        this.schema = schema;
        this.name = name;
        this.isKey = isKey;
        this.columnName = SchemaUtils.getSourceColumnName(schema).orElse(name);
        LOGGER.trace("Field [{}] with schema [{}]", (Object)this.name, (Object)schema.type());
        LOGGER.trace("    Optional  : {}", (Object)schema.isOptional());
        if (schema.parameters() != null && !schema.parameters().isEmpty()) {
            LOGGER.trace("    Parameters: {}", (Object)schema.parameters());
        }
        if (schema.defaultValue() != null) {
            LOGGER.trace("    Def. Value: {}", schema.defaultValue());
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String toString() {
        return "FieldDescriptor{schema=" + String.valueOf(this.schema) + ", name='" + this.name + "', isKey='" + this.isKey + "', columnName='" + this.columnName + "'}";
    }
}

