/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import java.util.HashMap;
import java.util.Map;

public enum ColumnType {
    DECIMAL(0),
    TINY(1),
    SHORT(2),
    LONG(3),
    FLOAT(4),
    DOUBLE(5),
    NULL(6),
    TIMESTAMP(7),
    LONGLONG(8),
    INT24(9),
    DATE(10),
    TIME(11),
    DATETIME(12),
    YEAR(13),
    NEWDATE(14),
    VARCHAR(15),
    BIT(16),
    TIMESTAMP_V2(17),
    DATETIME_V2(18),
    TIME_V2(19),
    VECTOR(242),
    JSON(245),
    NEWDECIMAL(246),
    ENUM(247),
    SET(248),
    TINY_BLOB(249),
    MEDIUM_BLOB(250),
    LONG_BLOB(251),
    BLOB(252),
    VAR_STRING(253),
    STRING(254),
    GEOMETRY(255);

    private int code;
    private static final Map<Integer, ColumnType> INDEX_BY_CODE;

    static {
        INDEX_BY_CODE = new HashMap<Integer, ColumnType>();
        ColumnType[] columnTypeArray = ColumnType.values();
        int n = columnTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnType columnType = columnTypeArray[n2];
            INDEX_BY_CODE.put(columnType.code, columnType);
            ++n2;
        }
    }

    private ColumnType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static ColumnType byCode(int code) {
        return INDEX_BY_CODE.get(code);
    }
}

