/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.network;

import com.github.shyiko.mysql.binlog.network.HostnameChecker;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class TLSHostnameVerifier
implements HostnameVerifier {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean verify(String hostname, SSLSession session) {
        HostnameChecker checker = HostnameChecker.DEFAULT;
        Certificate[] peerCertificates = session.getPeerCertificates();
        if (peerCertificates.length <= 0 || !(peerCertificates[0] instanceof X509Certificate)) return false;
        X509Certificate peerCertificate = (X509Certificate)peerCertificates[0];
        try {
            checker.check(hostname, peerCertificate);
            return true;
        }
        catch (SSLException sSLException) {
            try {
                return false;
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        return false;
    }
}

