package io.dekorate.knative.config;

import java.lang.Integer;
import java.lang.Object;
import io.sundr.builder.annotations.Buildable;

 /**
  * Generated
  */
  @Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class AutoScaling{
  public AutoScaling() {
  }
  public AutoScaling(AutoScalerClass autoScalerClass,AutoscalingMetric metric,Integer target,Integer containerConcurrency,Integer targetUtilizationPercentage) {
    this.autoScalerClass = autoScalerClass;
    this.metric = metric;
    this.target = target;
    this.containerConcurrency = containerConcurrency;
    this.targetUtilizationPercentage = targetUtilizationPercentage;
  }
  private AutoScalerClass autoScalerClass;
  private AutoscalingMetric metric;
  private Integer target;
  private Integer containerConcurrency;
  private Integer targetUtilizationPercentage;
  
  /**
   * The Autoscaler class.
   * Knative Serving comes with its own autoscaler, the KPA (Knative Pod Autoscaler) but can also be configured to use
   * Kubernetes’ HPA (Horizontal Pod Autoscaler) or even a custom third-party autoscaler.
   * Possible values (kpa, hpa, default: kpa).
   * @return The autoscaler class.
   */
public AutoScalerClass getAutoScalerClass() {
    return this.autoScalerClass;
  }
  
  /**
   * The autoscaling metric to use.
   * Possible values (concurency, rps, cpu).
   * @return The cpu metric or NONE if no metric has been selected.
   */
public AutoscalingMetric getMetric() {
    return this.metric;
  }
  
  /**
   * The autoscaling target.
   * @reutrn the selected target or zero if no target is selected.
   */
public Integer getTarget() {
    return this.target;
  }
  
  /**
   * The exact amount of requests allowed to the replica at a time.
   * Its default value is “0”, which means an unlimited number of requests are allowed to flow into the replica.
   * @return the container concurrenct or zero if its not bound.
   */
public Integer getContainerConcurrency() {
    return this.containerConcurrency;
  }
  
  /**
   * This value specifies a percentage of the target to actually be targeted by the autoscaler.
   */
public Integer getTargetUtilizationPercentage() {
    return this.targetUtilizationPercentage;
  }
  public static AutoScalingBuilder newBuilder() {
    return new AutoScalingBuilder();
  }
  public static AutoScalingBuilder newBuilderFromDefaults() {
    return new AutoScalingBuilder().withAutoScalerClass(io.dekorate.knative.config.AutoScalerClass.kpa).withMetric(io.dekorate.knative.config.AutoscalingMetric.concurrency).withTarget(0).withContainerConcurrency(0).withTargetUtilizationPercentage(70);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AutoScaling that = (AutoScaling) o;
    if (autoScalerClass != null ? !autoScalerClass.equals(that.autoScalerClass) :that.autoScalerClass != null) return false;
    if (metric != null ? !metric.equals(that.metric) :that.metric != null) return false;
    if (target != null ? !target.equals(that.target) :that.target != null) return false;
    if (containerConcurrency != null ? !containerConcurrency.equals(that.containerConcurrency) :that.containerConcurrency != null) return false;
    if (targetUtilizationPercentage != null ? !targetUtilizationPercentage.equals(that.targetUtilizationPercentage) :that.targetUtilizationPercentage != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(autoScalerClass,  metric,  target,  containerConcurrency,  targetUtilizationPercentage,  super.hashCode());
  }
  
}