package io.dekorate.knative.config;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AutoScalingFluentImpl<A extends AutoScalingFluent<A>> extends BaseFluent<A> implements AutoScalingFluent<A>{
  public AutoScalingFluentImpl() {
  }
  public AutoScalingFluentImpl(AutoScaling instance) {
    this.withAutoScalerClass(instance.getAutoScalerClass()); 
    this.withMetric(instance.getMetric()); 
    this.withTarget(instance.getTarget()); 
    this.withContainerConcurrency(instance.getContainerConcurrency()); 
    this.withTargetUtilizationPercentage(instance.getTargetUtilizationPercentage()); 
  }
  private AutoScalerClass autoScalerClass;
  private AutoscalingMetric metric;
  private Integer target;
  private Integer containerConcurrency;
  private Integer targetUtilizationPercentage;
  public AutoScalerClass getAutoScalerClass() {
    return this.autoScalerClass;
  }
  public A withAutoScalerClass(AutoScalerClass autoScalerClass) {
    this.autoScalerClass=autoScalerClass; return (A) this;
  }
  public Boolean hasAutoScalerClass() {
    return this.autoScalerClass != null;
  }
  public AutoscalingMetric getMetric() {
    return this.metric;
  }
  public A withMetric(AutoscalingMetric metric) {
    this.metric=metric; return (A) this;
  }
  public Boolean hasMetric() {
    return this.metric != null;
  }
  public Integer getTarget() {
    return this.target;
  }
  public A withTarget(Integer target) {
    this.target=target; return (A) this;
  }
  public Boolean hasTarget() {
    return this.target != null;
  }
  public Integer getContainerConcurrency() {
    return this.containerConcurrency;
  }
  public A withContainerConcurrency(Integer containerConcurrency) {
    this.containerConcurrency=containerConcurrency; return (A) this;
  }
  public Boolean hasContainerConcurrency() {
    return this.containerConcurrency != null;
  }
  public Integer getTargetUtilizationPercentage() {
    return this.targetUtilizationPercentage;
  }
  public A withTargetUtilizationPercentage(Integer targetUtilizationPercentage) {
    this.targetUtilizationPercentage=targetUtilizationPercentage; return (A) this;
  }
  public Boolean hasTargetUtilizationPercentage() {
    return this.targetUtilizationPercentage != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AutoScalingFluentImpl that = (AutoScalingFluentImpl) o;
    if (autoScalerClass != null ? !autoScalerClass.equals(that.autoScalerClass) :that.autoScalerClass != null) return false;
    if (metric != null ? !metric.equals(that.metric) :that.metric != null) return false;
    if (target != null ? !target.equals(that.target) :that.target != null) return false;
    if (containerConcurrency != null ? !containerConcurrency.equals(that.containerConcurrency) :that.containerConcurrency != null) return false;
    if (targetUtilizationPercentage != null ? !targetUtilizationPercentage.equals(that.targetUtilizationPercentage) :that.targetUtilizationPercentage != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(autoScalerClass,  metric,  target,  containerConcurrency,  targetUtilizationPercentage,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (autoScalerClass != null) { sb.append("autoScalerClass:"); sb.append(autoScalerClass + ","); }
    if (metric != null) { sb.append("metric:"); sb.append(metric + ","); }
    if (target != null) { sb.append("target:"); sb.append(target + ","); }
    if (containerConcurrency != null) { sb.append("containerConcurrency:"); sb.append(containerConcurrency + ","); }
    if (targetUtilizationPercentage != null) { sb.append("targetUtilizationPercentage:"); sb.append(targetUtilizationPercentage); }
    sb.append("}");
    return sb.toString();
  }
  
}