package io.dekorate.knative.config;

import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import io.dekorate.kubernetes.config.Job;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.HostAlias;
import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.config.CronJob;
import java.lang.Object;
import java.util.Map;
import io.dekorate.kubernetes.config.GitRepoVolume;

 /**
  * Generated
  */
  @Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class KnativeConfig extends BaseConfig{
  public KnativeConfig() {
  }
  public KnativeConfig(Project project,Map<ConfigKey,Object> attributes,String partOf,String name,String version,String deploymentKind,Label[] labels,Annotation[] annotations,Env[] envVars,String workingDir,String[] command,String[] arguments,String serviceAccount,Port[] ports,ServiceType serviceType,PersistentVolumeClaimVolume[] pvcVolumes,SecretVolume[] secretVolumes,ConfigMapVolume[] configMapVolumes,EmptyDirVolume[] emptyDirVolumes,GitRepoVolume[] gitRepoVolumes,AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes,AzureDiskVolume[] azureDiskVolumes,AzureFileVolume[] azureFileVolumes,Mount[] mounts,ImagePullPolicy imagePullPolicy,String[] imagePullSecrets,HostAlias[] hostAliases,Probe livenessProbe,Probe readinessProbe,Probe startupProbe,ResourceRequirements requestResources,ResourceRequirements limitResources,Container[] sidecars,Boolean autoDeployEnabled,Job[] jobs,CronJob[] cronJobs,String revisionName,String host,HttpTransportVersion httpTransportVersion,Boolean expose,Integer minScale,Integer maxScale,Boolean scaleToZeroEnabled,AutoScaling revisionAutoScaling,GlobalAutoScaling globalAutoScaling,String templateName,Traffic[] traffic) {
    super(project, attributes, partOf, name, version, deploymentKind, labels, annotations, envVars, workingDir, command, arguments, serviceAccount, ports, serviceType, pvcVolumes, secretVolumes, configMapVolumes, emptyDirVolumes, gitRepoVolumes, awsElasticBlockStoreVolumes, azureDiskVolumes, azureFileVolumes, mounts, imagePullPolicy, imagePullSecrets, hostAliases, livenessProbe, readinessProbe, startupProbe, requestResources, limitResources, sidecars, autoDeployEnabled, jobs, cronJobs);
    this.revisionName = revisionName;
    this.host = host;
    this.httpTransportVersion = httpTransportVersion;
    this.expose = expose;
    this.minScale = minScale;
    this.maxScale = maxScale;
    this.scaleToZeroEnabled = scaleToZeroEnabled;
    this.revisionAutoScaling = revisionAutoScaling;
    this.globalAutoScaling = globalAutoScaling;
    this.templateName = templateName;
    this.traffic = traffic != null ? traffic : new Traffic[0];
  }
  private String revisionName;
  private String host;
  private HttpTransportVersion httpTransportVersion;
  private Boolean expose;
  private Integer minScale;
  private Integer maxScale;
  private Boolean scaleToZeroEnabled;
  private AutoScaling revisionAutoScaling;
  private GlobalAutoScaling globalAutoScaling;
  private String templateName;
  private Traffic[] traffic = new Traffic[0];
  public String getRevisionName() {
    return this.revisionName;
  }
  
  /**
   * The host under which the application is going to be exposed.
   * @return The hostname.
   */
public String getHost() {
    return this.host;
  }
  
  /**
   * Http trasport version to use.
   */
public HttpTransportVersion getHttpTransportVersion() {
    return this.httpTransportVersion;
  }
  
  /**
   * Controls whether the application should be exposed (default: true).
   * Services that are not exposed with be labeled as cluster local (see
   * https://knative.dev/docs/serving/services/private-services).
   */
public Boolean getExpose() {
    return this.expose;
  }
  
  /**
   * Controls whether the application should be exposed (default: true).
   * Services that are not exposed with be labeled as cluster local (see
   * https://knative.dev/docs/serving/services/private-services).
   */
public boolean isExpose() {
    return this.expose != null &&  this.expose;
  }
  
  /**
   * This value controls the minimum number of replicas each revision should have.
   * Knative will attempt to never have less than this number of replicas at any one point in time.
   */
public Integer getMinScale() {
    return this.minScale;
  }
  
  /**
   * This value controls the maximum number of replicas each revision should have.
   * Knative will attempt to never have more than this number of replicas running, or in the process of being created, at any
   * one point in time.
   */
public Integer getMaxScale() {
    return this.maxScale;
  }
  
  /**
   * The scale-to-zero values control whether Knative allows revisions to scale down to zero, or stops at “1”.
   */
public Boolean getScaleToZeroEnabled() {
    return this.scaleToZeroEnabled;
  }
  
  /**
   * The scale-to-zero values control whether Knative allows revisions to scale down to zero, or stops at “1”.
   */
public boolean isScaleToZeroEnabled() {
    return this.scaleToZeroEnabled != null &&  this.scaleToZeroEnabled;
  }
  
  /**
   * Revision autoscaling configuration.
   */
public AutoScaling getRevisionAutoScaling() {
    return this.revisionAutoScaling;
  }
  
  /**
   * Global autoscaling configuration.
   */
public GlobalAutoScaling getGlobalAutoScaling() {
    return this.globalAutoScaling;
  }
  
  /**
   * The template name to specify.
   */
public String getTemplateName() {
    return this.templateName;
  }
  
  /**
   * Traffic configuration for the application.
   */
public Traffic[] getTraffic() {
    return this.traffic;
  }
  public static KnativeConfigBuilder newKnativeConfigBuilder() {
    return new KnativeConfigBuilder();
  }
  public static KnativeConfigBuilder newKnativeConfigBuilderFromDefaults() {
    return new KnativeConfigBuilder().withHttpTransportVersion(io.dekorate.knative.config.HttpTransportVersion.HTTP1).withServiceType(io.dekorate.kubernetes.annotation.ServiceType.ClusterIP).withImagePullPolicy(io.dekorate.kubernetes.annotation.ImagePullPolicy.IfNotPresent).withExpose(true).withAutoDeployEnabled(false).withMinScale(0).withMaxScale(0).withScaleToZeroEnabled(true);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KnativeConfig that = (KnativeConfig) o;
    if (revisionName != null ? !revisionName.equals(that.revisionName) :that.revisionName != null) return false;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (httpTransportVersion != null ? !httpTransportVersion.equals(that.httpTransportVersion) :that.httpTransportVersion != null) return false;
    if (expose != null ? !expose.equals(that.expose) :that.expose != null) return false;
    if (minScale != null ? !minScale.equals(that.minScale) :that.minScale != null) return false;
    if (maxScale != null ? !maxScale.equals(that.maxScale) :that.maxScale != null) return false;
    if (scaleToZeroEnabled != null ? !scaleToZeroEnabled.equals(that.scaleToZeroEnabled) :that.scaleToZeroEnabled != null) return false;
    if (revisionAutoScaling != null ? !revisionAutoScaling.equals(that.revisionAutoScaling) :that.revisionAutoScaling != null) return false;
    if (globalAutoScaling != null ? !globalAutoScaling.equals(that.globalAutoScaling) :that.globalAutoScaling != null) return false;
    if (templateName != null ? !templateName.equals(that.templateName) :that.templateName != null) return false;
    if (traffic != null ? !traffic.equals(that.traffic) :that.traffic != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(revisionName,  host,  httpTransportVersion,  expose,  minScale,  maxScale,  scaleToZeroEnabled,  revisionAutoScaling,  globalAutoScaling,  templateName,  traffic,  super.hashCode());
  }
  
}