package io.dekorate.knative.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import io.dekorate.kubernetes.config.BaseConfigFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KnativeConfigFluentImpl<A extends KnativeConfigFluent<A>> extends BaseConfigFluentImpl<A> implements KnativeConfigFluent<A>{
  public KnativeConfigFluentImpl() {
  }
  public KnativeConfigFluentImpl(KnativeConfig instance) {
    this.withProject(instance.getProject()); 
    this.withAttributes(instance.getAttributes()); 
    this.withPartOf(instance.getPartOf()); 
    this.withName(instance.getName()); 
    this.withVersion(instance.getVersion()); 
    this.withDeploymentKind(instance.getDeploymentKind()); 
    this.withLabels(instance.getLabels()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withEnvVars(instance.getEnvVars()); 
    this.withWorkingDir(instance.getWorkingDir()); 
    this.withCommand(instance.getCommand()); 
    this.withArguments(instance.getArguments()); 
    this.withServiceAccount(instance.getServiceAccount()); 
    this.withPorts(instance.getPorts()); 
    this.withServiceType(instance.getServiceType()); 
    this.withPvcVolumes(instance.getPvcVolumes()); 
    this.withSecretVolumes(instance.getSecretVolumes()); 
    this.withConfigMapVolumes(instance.getConfigMapVolumes()); 
    this.withEmptyDirVolumes(instance.getEmptyDirVolumes()); 
    this.withGitRepoVolumes(instance.getGitRepoVolumes()); 
    this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes()); 
    this.withAzureDiskVolumes(instance.getAzureDiskVolumes()); 
    this.withAzureFileVolumes(instance.getAzureFileVolumes()); 
    this.withMounts(instance.getMounts()); 
    this.withImagePullPolicy(instance.getImagePullPolicy()); 
    this.withImagePullSecrets(instance.getImagePullSecrets()); 
    this.withHostAliases(instance.getHostAliases()); 
    this.withLivenessProbe(instance.getLivenessProbe()); 
    this.withReadinessProbe(instance.getReadinessProbe()); 
    this.withStartupProbe(instance.getStartupProbe()); 
    this.withRequestResources(instance.getRequestResources()); 
    this.withLimitResources(instance.getLimitResources()); 
    this.withSidecars(instance.getSidecars()); 
    this.withAutoDeployEnabled(instance.getAutoDeployEnabled()); 
    this.withJobs(instance.getJobs()); 
    this.withCronJobs(instance.getCronJobs()); 
    this.withRevisionName(instance.getRevisionName()); 
    this.withHost(instance.getHost()); 
    this.withHttpTransportVersion(instance.getHttpTransportVersion()); 
    this.withExpose(instance.getExpose()); 
    this.withMinScale(instance.getMinScale()); 
    this.withMaxScale(instance.getMaxScale()); 
    this.withScaleToZeroEnabled(instance.getScaleToZeroEnabled()); 
    this.withRevisionAutoScaling(instance.getRevisionAutoScaling()); 
    this.withGlobalAutoScaling(instance.getGlobalAutoScaling()); 
    this.withTemplateName(instance.getTemplateName()); 
    this.withTraffic(instance.getTraffic()); 
  }
  private String revisionName;
  private String host;
  private HttpTransportVersion httpTransportVersion;
  private Boolean expose;
  private Integer minScale;
  private Integer maxScale;
  private Boolean scaleToZeroEnabled;
  private AutoScalingBuilder revisionAutoScaling;
  private GlobalAutoScalingBuilder globalAutoScaling;
  private String templateName;
  private ArrayList<TrafficBuilder> traffic = new ArrayList<TrafficBuilder>();
  public String getRevisionName() {
    return this.revisionName;
  }
  public A withRevisionName(String revisionName) {
    this.revisionName=revisionName; return (A) this;
  }
  public Boolean hasRevisionName() {
    return this.revisionName != null;
  }
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public Boolean hasHost() {
    return this.host != null;
  }
  public HttpTransportVersion getHttpTransportVersion() {
    return this.httpTransportVersion;
  }
  public A withHttpTransportVersion(HttpTransportVersion httpTransportVersion) {
    this.httpTransportVersion=httpTransportVersion; return (A) this;
  }
  public Boolean hasHttpTransportVersion() {
    return this.httpTransportVersion != null;
  }
  public Boolean getExpose() {
    return this.expose;
  }
  public A withExpose(Boolean expose) {
    this.expose=expose; return (A) this;
  }
  public Boolean hasExpose() {
    return this.expose != null;
  }
  public Integer getMinScale() {
    return this.minScale;
  }
  public A withMinScale(Integer minScale) {
    this.minScale=minScale; return (A) this;
  }
  public Boolean hasMinScale() {
    return this.minScale != null;
  }
  public Integer getMaxScale() {
    return this.maxScale;
  }
  public A withMaxScale(Integer maxScale) {
    this.maxScale=maxScale; return (A) this;
  }
  public Boolean hasMaxScale() {
    return this.maxScale != null;
  }
  public Boolean getScaleToZeroEnabled() {
    return this.scaleToZeroEnabled;
  }
  public A withScaleToZeroEnabled(Boolean scaleToZeroEnabled) {
    this.scaleToZeroEnabled=scaleToZeroEnabled; return (A) this;
  }
  public Boolean hasScaleToZeroEnabled() {
    return this.scaleToZeroEnabled != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRevisionAutoScaling instead.
   * @return The buildable object.
   */
  @Deprecated
  public AutoScaling getRevisionAutoScaling() {
    return this.revisionAutoScaling!=null ?this.revisionAutoScaling.build():null;
  }
  public AutoScaling buildRevisionAutoScaling() {
    return this.revisionAutoScaling!=null ?this.revisionAutoScaling.build():null;
  }
  public A withRevisionAutoScaling(AutoScaling revisionAutoScaling) {
    _visitables.get("revisionAutoScaling").remove(this.revisionAutoScaling);
    if (revisionAutoScaling!=null){ this.revisionAutoScaling= new AutoScalingBuilder(revisionAutoScaling); _visitables.get("revisionAutoScaling").add(this.revisionAutoScaling);} else { this.revisionAutoScaling = null; _visitables.get("revisionAutoScaling").remove(this.revisionAutoScaling); } return (A) this;
  }
  public Boolean hasRevisionAutoScaling() {
    return this.revisionAutoScaling != null;
  }
  public KnativeConfigFluent.RevisionAutoScalingNested<A> withNewRevisionAutoScaling() {
    return new KnativeConfigFluentImpl.RevisionAutoScalingNestedImpl();
  }
  public KnativeConfigFluent.RevisionAutoScalingNested<A> withNewRevisionAutoScalingLike(AutoScaling item) {
    return new KnativeConfigFluentImpl.RevisionAutoScalingNestedImpl(item);
  }
  public KnativeConfigFluent.RevisionAutoScalingNested<A> editRevisionAutoScaling() {
    return withNewRevisionAutoScalingLike(getRevisionAutoScaling());
  }
  public KnativeConfigFluent.RevisionAutoScalingNested<A> editOrNewRevisionAutoScaling() {
    return withNewRevisionAutoScalingLike(getRevisionAutoScaling() != null ? getRevisionAutoScaling(): new AutoScalingBuilder().build());
  }
  public KnativeConfigFluent.RevisionAutoScalingNested<A> editOrNewRevisionAutoScalingLike(AutoScaling item) {
    return withNewRevisionAutoScalingLike(getRevisionAutoScaling() != null ? getRevisionAutoScaling(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGlobalAutoScaling instead.
   * @return The buildable object.
   */
  @Deprecated
  public GlobalAutoScaling getGlobalAutoScaling() {
    return this.globalAutoScaling!=null ?this.globalAutoScaling.build():null;
  }
  public GlobalAutoScaling buildGlobalAutoScaling() {
    return this.globalAutoScaling!=null ?this.globalAutoScaling.build():null;
  }
  public A withGlobalAutoScaling(GlobalAutoScaling globalAutoScaling) {
    _visitables.get("globalAutoScaling").remove(this.globalAutoScaling);
    if (globalAutoScaling!=null){ this.globalAutoScaling= new GlobalAutoScalingBuilder(globalAutoScaling); _visitables.get("globalAutoScaling").add(this.globalAutoScaling);} else { this.globalAutoScaling = null; _visitables.get("globalAutoScaling").remove(this.globalAutoScaling); } return (A) this;
  }
  public Boolean hasGlobalAutoScaling() {
    return this.globalAutoScaling != null;
  }
  public KnativeConfigFluent.GlobalAutoScalingNested<A> withNewGlobalAutoScaling() {
    return new KnativeConfigFluentImpl.GlobalAutoScalingNestedImpl();
  }
  public KnativeConfigFluent.GlobalAutoScalingNested<A> withNewGlobalAutoScalingLike(GlobalAutoScaling item) {
    return new KnativeConfigFluentImpl.GlobalAutoScalingNestedImpl(item);
  }
  public KnativeConfigFluent.GlobalAutoScalingNested<A> editGlobalAutoScaling() {
    return withNewGlobalAutoScalingLike(getGlobalAutoScaling());
  }
  public KnativeConfigFluent.GlobalAutoScalingNested<A> editOrNewGlobalAutoScaling() {
    return withNewGlobalAutoScalingLike(getGlobalAutoScaling() != null ? getGlobalAutoScaling(): new GlobalAutoScalingBuilder().build());
  }
  public KnativeConfigFluent.GlobalAutoScalingNested<A> editOrNewGlobalAutoScalingLike(GlobalAutoScaling item) {
    return withNewGlobalAutoScalingLike(getGlobalAutoScaling() != null ? getGlobalAutoScaling(): item);
  }
  public String getTemplateName() {
    return this.templateName;
  }
  public A withTemplateName(String templateName) {
    this.templateName=templateName; return (A) this;
  }
  public Boolean hasTemplateName() {
    return this.templateName != null;
  }
  public A withTraffic(io.dekorate.knative.config.Traffic... traffic) {
    if (this.traffic != null) {this.traffic.clear();}
    if (traffic != null) {for (Traffic item :traffic){ this.addToTraffic(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildTraffic instead.
   */
  @Deprecated
  public Traffic[] getTraffic() {
    int size = traffic != null ? traffic.size() : 0;
Traffic[] result = new Traffic[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends Traffic,?> builder : traffic) {
    result[index++]=builder.build();
}
return result;

  }
  public Traffic[] buildTraffic() {
    int size = traffic != null ? traffic.size() : 0;
Traffic[] result = new Traffic[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends Traffic,?> builder : traffic) {
    result[index++]=builder.build();
}
return result;

  }
  public Traffic buildTraffic(Integer index) {
    return this.traffic.get(index).build();
  }
  public Traffic buildFirstTraffic() {
    return this.traffic.get(0).build();
  }
  public Traffic buildLastTraffic() {
    return this.traffic.get(traffic.size() - 1).build();
  }
  public Traffic buildMatchingTraffic(Predicate<TrafficBuilder> predicate) {
    for (TrafficBuilder item: traffic) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTraffic(Predicate<TrafficBuilder> predicate) {
    for (TrafficBuilder item: traffic) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToTraffic(Integer index,Traffic item) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficBuilder>();}
    TrafficBuilder builder = new TrafficBuilder(item);_visitables.get("traffic").add(index >= 0 ? index : _visitables.get("traffic").size(), builder);this.traffic.add(index >= 0 ? index : traffic.size(), builder); return (A)this;
  }
  public A setToTraffic(Integer index,Traffic item) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficBuilder>();}
    TrafficBuilder builder = new TrafficBuilder(item);
    if (index < 0 || index >= _visitables.get("traffic").size()) { _visitables.get("traffic").add(builder); } else { _visitables.get("traffic").set(index, builder);}
    if (index < 0 || index >= traffic.size()) { traffic.add(builder); } else { traffic.set(index, builder);}
     return (A)this;
  }
  public A addToTraffic(io.dekorate.knative.config.Traffic... items) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficBuilder>();}
    for (Traffic item : items) {TrafficBuilder builder = new TrafficBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
  }
  public A addAllToTraffic(Collection<Traffic> items) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficBuilder>();}
    for (Traffic item : items) {TrafficBuilder builder = new TrafficBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
  }
  public A removeFromTraffic(io.dekorate.knative.config.Traffic... items) {
    for (Traffic item : items) {TrafficBuilder builder = new TrafficBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
  }
  public A removeAllFromTraffic(Collection<Traffic> items) {
    for (Traffic item : items) {TrafficBuilder builder = new TrafficBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTraffic(Predicate<TrafficBuilder> predicate) {
    if (traffic == null) return (A) this;
    final Iterator<TrafficBuilder> each = traffic.iterator();
    final List visitables = _visitables.get("traffic");
    while (each.hasNext()) {
      TrafficBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasTraffic() {
    return traffic != null && !traffic.isEmpty();
  }
  public A addNewTraffic(String tag,String revisionName,Boolean latestRevision,Integer percentage) {
    return (A)addToTraffic(new Traffic(tag, revisionName, latestRevision, percentage));
  }
  public KnativeConfigFluent.TrafficNested<A> addNewTraffic() {
    return new KnativeConfigFluentImpl.TrafficNestedImpl();
  }
  public KnativeConfigFluent.TrafficNested<A> addNewTrafficLike(Traffic item) {
    return new KnativeConfigFluentImpl.TrafficNestedImpl(-1, item);
  }
  public KnativeConfigFluent.TrafficNested<A> setNewTrafficLike(Integer index,Traffic item) {
    return new KnativeConfigFluentImpl.TrafficNestedImpl(index, item);
  }
  public KnativeConfigFluent.TrafficNested<A> editTraffic(Integer index) {
    if (traffic.size() <= index) throw new RuntimeException("Can't edit traffic. Index exceeds size.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  public KnativeConfigFluent.TrafficNested<A> editFirstTraffic() {
    if (traffic.size() == 0) throw new RuntimeException("Can't edit first traffic. The list is empty.");
    return setNewTrafficLike(0, buildTraffic(0));
  }
  public KnativeConfigFluent.TrafficNested<A> editLastTraffic() {
    int index = traffic.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last traffic. The list is empty.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  public KnativeConfigFluent.TrafficNested<A> editMatchingTraffic(Predicate<TrafficBuilder> predicate) {
    int index = -1;
    for (int i=0;i<traffic.size();i++) { 
    if (predicate.test(traffic.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching traffic. No match found.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KnativeConfigFluentImpl that = (KnativeConfigFluentImpl) o;
    if (revisionName != null ? !revisionName.equals(that.revisionName) :that.revisionName != null) return false;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (httpTransportVersion != null ? !httpTransportVersion.equals(that.httpTransportVersion) :that.httpTransportVersion != null) return false;
    if (expose != null ? !expose.equals(that.expose) :that.expose != null) return false;
    if (minScale != null ? !minScale.equals(that.minScale) :that.minScale != null) return false;
    if (maxScale != null ? !maxScale.equals(that.maxScale) :that.maxScale != null) return false;
    if (scaleToZeroEnabled != null ? !scaleToZeroEnabled.equals(that.scaleToZeroEnabled) :that.scaleToZeroEnabled != null) return false;
    if (revisionAutoScaling != null ? !revisionAutoScaling.equals(that.revisionAutoScaling) :that.revisionAutoScaling != null) return false;
    if (globalAutoScaling != null ? !globalAutoScaling.equals(that.globalAutoScaling) :that.globalAutoScaling != null) return false;
    if (templateName != null ? !templateName.equals(that.templateName) :that.templateName != null) return false;
    if (traffic != null ? !traffic.equals(that.traffic) :that.traffic != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(revisionName,  host,  httpTransportVersion,  expose,  minScale,  maxScale,  scaleToZeroEnabled,  revisionAutoScaling,  globalAutoScaling,  templateName,  traffic,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (revisionName != null) { sb.append("revisionName:"); sb.append(revisionName + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (httpTransportVersion != null) { sb.append("httpTransportVersion:"); sb.append(httpTransportVersion + ","); }
    if (expose != null) { sb.append("expose:"); sb.append(expose + ","); }
    if (minScale != null) { sb.append("minScale:"); sb.append(minScale + ","); }
    if (maxScale != null) { sb.append("maxScale:"); sb.append(maxScale + ","); }
    if (scaleToZeroEnabled != null) { sb.append("scaleToZeroEnabled:"); sb.append(scaleToZeroEnabled + ","); }
    if (revisionAutoScaling != null) { sb.append("revisionAutoScaling:"); sb.append(revisionAutoScaling + ","); }
    if (globalAutoScaling != null) { sb.append("globalAutoScaling:"); sb.append(globalAutoScaling + ","); }
    if (templateName != null) { sb.append("templateName:"); sb.append(templateName + ","); }
    if (traffic != null && !traffic.isEmpty()) { sb.append("traffic:"); sb.append(traffic); }
    sb.append("}");
    return sb.toString();
  }
  public A withExpose() {
    return withExpose(true);
  }
  public A withScaleToZeroEnabled() {
    return withScaleToZeroEnabled(true);
  }
  class RevisionAutoScalingNestedImpl<N> extends AutoScalingFluentImpl<KnativeConfigFluent.RevisionAutoScalingNested<N>> implements KnativeConfigFluent.RevisionAutoScalingNested<N>,Nested<N>{
    RevisionAutoScalingNestedImpl(AutoScaling item) {
      this.builder = new AutoScalingBuilder(this, item);
    }
    RevisionAutoScalingNestedImpl() {
      this.builder = new AutoScalingBuilder(this);
    }
    AutoScalingBuilder builder;
    public N and() {
      return (N) KnativeConfigFluentImpl.this.withRevisionAutoScaling(builder.build());
    }
    public N endRevisionAutoScaling() {
      return and();
    }
    
  }
  class GlobalAutoScalingNestedImpl<N> extends GlobalAutoScalingFluentImpl<KnativeConfigFluent.GlobalAutoScalingNested<N>> implements KnativeConfigFluent.GlobalAutoScalingNested<N>,Nested<N>{
    GlobalAutoScalingNestedImpl(GlobalAutoScaling item) {
      this.builder = new GlobalAutoScalingBuilder(this, item);
    }
    GlobalAutoScalingNestedImpl() {
      this.builder = new GlobalAutoScalingBuilder(this);
    }
    GlobalAutoScalingBuilder builder;
    public N and() {
      return (N) KnativeConfigFluentImpl.this.withGlobalAutoScaling(builder.build());
    }
    public N endGlobalAutoScaling() {
      return and();
    }
    
  }
  class TrafficNestedImpl<N> extends TrafficFluentImpl<KnativeConfigFluent.TrafficNested<N>> implements KnativeConfigFluent.TrafficNested<N>,Nested<N>{
    TrafficNestedImpl(Integer index,Traffic item) {
      this.index = index;
      this.builder = new TrafficBuilder(this, item);
    }
    TrafficNestedImpl() {
      this.index = -1;
      this.builder = new TrafficBuilder(this);
    }
    TrafficBuilder builder;
    Integer index;
    public N and() {
      return (N) KnativeConfigFluentImpl.this.setToTraffic(index,builder.build());
    }
    public N endTraffic() {
      return and();
    }
    
  }
  
}