/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;

@Description(value="Add an elastic block store volume to the pod spec.")
public class AddAwsElasticBlockStoreVolumeDecorator
extends NamedResourceDecorator<PodSpecFluent<?>> {
    private final AwsElasticBlockStoreVolume volume;

    public AddAwsElasticBlockStoreVolumeDecorator(AwsElasticBlockStoreVolume volume) {
        this(ANY, volume);
    }

    public AddAwsElasticBlockStoreVolumeDecorator(String name, AwsElasticBlockStoreVolume volume) {
        super(name);
        this.volume = volume;
    }

    @Override
    public void andThenVisit(PodSpecFluent<?> podSpec, ObjectMeta resourceMeta) {
        ((PodSpecFluent.VolumesNested)((VolumeFluent.AwsElasticBlockStoreNested)((VolumeFluent.AwsElasticBlockStoreNested)((VolumeFluent.AwsElasticBlockStoreNested)((VolumeFluent.AwsElasticBlockStoreNested)((PodSpecFluent.VolumesNested)podSpec.addNewVolume().withName(this.volume.getVolumeName())).withNewAwsElasticBlockStore().withVolumeID(this.volume.getVolumeId())).withFsType(this.volume.getFsType())).withPartition(this.volume.getPartition())).withReadOnly(Boolean.valueOf(this.volume.isReadOnly()))).endAwsElasticBlockStore()).endVolume();
    }
}

