package io.dekorate.openshift.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.dekorate.kubernetes.config.ContainerFluentImpl;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import io.dekorate.kubernetes.config.BaseConfigFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OpenshiftConfigFluentImpl<A extends OpenshiftConfigFluent<A>> extends BaseConfigFluentImpl<A> implements OpenshiftConfigFluent<A>{
  public OpenshiftConfigFluentImpl() {
  }
  public OpenshiftConfigFluentImpl(OpenshiftConfig instance) {
    this.withProject(instance.getProject()); 
    this.withAttributes(instance.getAttributes()); 
    this.withPartOf(instance.getPartOf()); 
    this.withName(instance.getName()); 
    this.withVersion(instance.getVersion()); 
    this.withDeploymentKind(instance.getDeploymentKind()); 
    this.withLabels(instance.getLabels()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withEnvVars(instance.getEnvVars()); 
    this.withWorkingDir(instance.getWorkingDir()); 
    this.withCommand(instance.getCommand()); 
    this.withArguments(instance.getArguments()); 
    this.withServiceAccount(instance.getServiceAccount()); 
    this.withPorts(instance.getPorts()); 
    this.withServiceType(instance.getServiceType()); 
    this.withPvcVolumes(instance.getPvcVolumes()); 
    this.withSecretVolumes(instance.getSecretVolumes()); 
    this.withConfigMapVolumes(instance.getConfigMapVolumes()); 
    this.withEmptyDirVolumes(instance.getEmptyDirVolumes()); 
    this.withGitRepoVolumes(instance.getGitRepoVolumes()); 
    this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes()); 
    this.withAzureDiskVolumes(instance.getAzureDiskVolumes()); 
    this.withAzureFileVolumes(instance.getAzureFileVolumes()); 
    this.withMounts(instance.getMounts()); 
    this.withImagePullPolicy(instance.getImagePullPolicy()); 
    this.withImagePullSecrets(instance.getImagePullSecrets()); 
    this.withHostAliases(instance.getHostAliases()); 
    this.withLivenessProbe(instance.getLivenessProbe()); 
    this.withReadinessProbe(instance.getReadinessProbe()); 
    this.withStartupProbe(instance.getStartupProbe()); 
    this.withRequestResources(instance.getRequestResources()); 
    this.withLimitResources(instance.getLimitResources()); 
    this.withSidecars(instance.getSidecars()); 
    this.withAutoDeployEnabled(instance.getAutoDeployEnabled()); 
    this.withJobs(instance.getJobs()); 
    this.withCronJobs(instance.getCronJobs()); 
    this.withInitContainers(instance.getInitContainers()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRoute(instance.getRoute()); 
    this.withHeadless(instance.getHeadless()); 
  }
  private ArrayList<ContainerBuilder> initContainers = new ArrayList<ContainerBuilder>();
  private Integer replicas;
  private RouteBuilder route;
  private Boolean headless;
  public A withInitContainers(io.dekorate.kubernetes.config.Container... initContainers) {
    if (this.initContainers != null) {this.initContainers.clear();}
    if (initContainers != null) {for (Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   */
  @Deprecated
  public Container[] getInitContainers() {
    int size = initContainers != null ? initContainers.size() : 0;
Container[] result = new Container[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends Container,?> builder : initContainers) {
    result[index++]=builder.build();
}
return result;

  }
  public Container[] buildInitContainers() {
    int size = initContainers != null ? initContainers.size() : 0;
Container[] result = new Container[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends Container,?> builder : initContainers) {
    result[index++]=builder.build();
}
return result;

  }
  public Container buildInitContainer(Integer index) {
    return this.initContainers.get(index).build();
  }
  public Container buildFirstInitContainer() {
    return this.initContainers.get(0).build();
  }
  public Container buildLastInitContainer() {
    return this.initContainers.get(initContainers.size() - 1).build();
  }
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToInitContainers(Integer index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(index >= 0 ? index : _visitables.get("initContainers").size(), builder);this.initContainers.add(index >= 0 ? index : initContainers.size(), builder); return (A)this;
  }
  public A setToInitContainers(Integer index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("initContainers").size()) { _visitables.get("initContainers").add(builder); } else { _visitables.get("initContainers").set(index, builder);}
    if (index < 0 || index >= initContainers.size()) { initContainers.add(builder); } else { initContainers.set(index, builder);}
     return (A)this;
  }
  public A addToInitContainers(io.dekorate.kubernetes.config.Container... items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A addAllToInitContainers(Collection<Container> items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A removeFromInitContainers(io.dekorate.kubernetes.config.Container... items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromInitContainers(Collection<Container> items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
    if (initContainers == null) return (A) this;
    final Iterator<ContainerBuilder> each = initContainers.iterator();
    final List visitables = _visitables.get("initContainers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasInitContainers() {
    return initContainers != null && !initContainers.isEmpty();
  }
  public OpenshiftConfigFluent.InitContainersNested<A> addNewInitContainer() {
    return new OpenshiftConfigFluentImpl.InitContainersNestedImpl();
  }
  public OpenshiftConfigFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
    return new OpenshiftConfigFluentImpl.InitContainersNestedImpl(-1, item);
  }
  public OpenshiftConfigFluent.InitContainersNested<A> setNewInitContainerLike(Integer index,Container item) {
    return new OpenshiftConfigFluentImpl.InitContainersNestedImpl(index, item);
  }
  public OpenshiftConfigFluent.InitContainersNested<A> editInitContainer(Integer index) {
    if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public OpenshiftConfigFluent.InitContainersNested<A> editFirstInitContainer() {
    if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
    return setNewInitContainerLike(0, buildInitContainer(0));
  }
  public OpenshiftConfigFluent.InitContainersNested<A> editLastInitContainer() {
    int index = initContainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public OpenshiftConfigFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainers.size();i++) { 
    if (predicate.test(initContainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRoute instead.
   * @return The buildable object.
   */
  @Deprecated
  public Route getRoute() {
    return this.route!=null ?this.route.build():null;
  }
  public Route buildRoute() {
    return this.route!=null ?this.route.build():null;
  }
  public A withRoute(Route route) {
    _visitables.get("route").remove(this.route);
    if (route!=null){ this.route= new RouteBuilder(route); _visitables.get("route").add(this.route);} else { this.route = null; _visitables.get("route").remove(this.route); } return (A) this;
  }
  public Boolean hasRoute() {
    return this.route != null;
  }
  public A withNewRoute(Boolean expose,String host,String targetPort) {
    return (A)withRoute(new Route(expose, host, targetPort));
  }
  public OpenshiftConfigFluent.RouteNested<A> withNewRoute() {
    return new OpenshiftConfigFluentImpl.RouteNestedImpl();
  }
  public OpenshiftConfigFluent.RouteNested<A> withNewRouteLike(Route item) {
    return new OpenshiftConfigFluentImpl.RouteNestedImpl(item);
  }
  public OpenshiftConfigFluent.RouteNested<A> editRoute() {
    return withNewRouteLike(getRoute());
  }
  public OpenshiftConfigFluent.RouteNested<A> editOrNewRoute() {
    return withNewRouteLike(getRoute() != null ? getRoute(): new RouteBuilder().build());
  }
  public OpenshiftConfigFluent.RouteNested<A> editOrNewRouteLike(Route item) {
    return withNewRouteLike(getRoute() != null ? getRoute(): item);
  }
  public Boolean getHeadless() {
    return this.headless;
  }
  public A withHeadless(Boolean headless) {
    this.headless=headless; return (A) this;
  }
  public Boolean hasHeadless() {
    return this.headless != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OpenshiftConfigFluentImpl that = (OpenshiftConfigFluentImpl) o;
    if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (route != null ? !route.equals(that.route) :that.route != null) return false;
    if (headless != null ? !headless.equals(that.headless) :that.headless != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(initContainers,  replicas,  route,  headless,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (initContainers != null && !initContainers.isEmpty()) { sb.append("initContainers:"); sb.append(initContainers + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (route != null) { sb.append("route:"); sb.append(route + ","); }
    if (headless != null) { sb.append("headless:"); sb.append(headless); }
    sb.append("}");
    return sb.toString();
  }
  public A withHeadless() {
    return withHeadless(true);
  }
  class InitContainersNestedImpl<N> extends ContainerFluentImpl<OpenshiftConfigFluent.InitContainersNested<N>> implements OpenshiftConfigFluent.InitContainersNested<N>,Nested<N>{
    InitContainersNestedImpl(Integer index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    InitContainersNestedImpl() {
      this.index = -1;
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    Integer index;
    public N and() {
      return (N) OpenshiftConfigFluentImpl.this.setToInitContainers(index,builder.build());
    }
    public N endInitContainer() {
      return and();
    }
    
  }
  class RouteNestedImpl<N> extends RouteFluentImpl<OpenshiftConfigFluent.RouteNested<N>> implements OpenshiftConfigFluent.RouteNested<N>,Nested<N>{
    RouteNestedImpl(Route item) {
      this.builder = new RouteBuilder(this, item);
    }
    RouteNestedImpl() {
      this.builder = new RouteBuilder(this);
    }
    RouteBuilder builder;
    public N and() {
      return (N) OpenshiftConfigFluentImpl.this.withRoute(builder.build());
    }
    public N endRoute() {
      return and();
    }
    
  }
  
}