package io.dekorate.option.config;

import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import java.lang.Object;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import io.dekorate.option.annotation.SecureRandomSource;
import java.lang.Boolean;
import java.util.Map;
import io.dekorate.option.annotation.GarbageCollector;

 /**
  * Generated
  */
public interface JvmConfigFluent<A extends JvmConfigFluent<A>> extends ConfigurationFluent<A>{
  public Integer getXms();
  public A withXms(Integer xms);
  public Boolean hasXms();
  public Integer getXmx();
  public A withXmx(Integer xmx);
  public Boolean hasXmx();
  public Boolean getServer();
  public A withServer(Boolean server);
  public Boolean hasServer();
  public Boolean getUseStringDeduplication();
  public A withUseStringDeduplication(Boolean useStringDeduplication);
  public Boolean hasUseStringDeduplication();
  public Boolean getPreferIPv4Stack();
  public A withPreferIPv4Stack(Boolean preferIPv4Stack);
  public Boolean hasPreferIPv4Stack();
  public Boolean getHeapDumpOnOutOfMemoryError();
  public A withHeapDumpOnOutOfMemoryError(Boolean heapDumpOnOutOfMemoryError);
  public Boolean hasHeapDumpOnOutOfMemoryError();
  public Boolean getUseGCOverheadLimit();
  public A withUseGCOverheadLimit(Boolean useGCOverheadLimit);
  public Boolean hasUseGCOverheadLimit();
  public GarbageCollector getGc();
  public A withGc(GarbageCollector gc);
  public Boolean hasGc();
  public SecureRandomSource getSecureRandom();
  public A withSecureRandom(SecureRandomSource secureRandom);
  public Boolean hasSecureRandom();
  public A withServer();
  public A withUseStringDeduplication();
  public A withPreferIPv4Stack();
  public A withHeapDumpOnOutOfMemoryError();
  public A withUseGCOverheadLimit();
  
}