/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.skipping;

import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class StatsSchemaHelper {
    private final StructType dataSchema;
    private final Map<Column, Column> logicalToPhysicalColumn;
    private final Map<Column, DataType> logicalToDataType;
    private static final String NUM_RECORDS = "numRecords";
    private static final String MIN = "minValues";
    private static final String MAX = "maxValues";
    private static final String NULL_COUNT = "nullCount";
    private static final Set<String> SKIPPING_ELIGIBLE_TYPE_NAMES = new HashSet<String>(){
        {
            this.add("byte");
            this.add("short");
            this.add("integer");
            this.add("long");
            this.add("float");
            this.add("double");
            this.add("date");
            this.add("timestamp");
            this.add("string");
        }
    };

    public static boolean isSkippingEligibleLiteral(Literal literal) {
        return StatsSchemaHelper.isSkippingEligibleDataType(literal.getDataType());
    }

    public static StructType getStatsSchema(StructType structType) {
        StructType structType2;
        StructType structType3 = new StructType().add(NUM_RECORDS, (DataType)LongType.LONG, true);
        StructType structType4 = StatsSchemaHelper.getMinMaxStatsSchema(structType);
        if (structType4.length() > 0) {
            structType3 = structType3.add(MIN, (DataType)StatsSchemaHelper.getMinMaxStatsSchema(structType), true).add(MAX, (DataType)StatsSchemaHelper.getMinMaxStatsSchema(structType), true);
        }
        if ((structType2 = StatsSchemaHelper.getNullCountSchema(structType)).length() > 0) {
            structType3 = structType3.add(NULL_COUNT, (DataType)StatsSchemaHelper.getNullCountSchema(structType), true);
        }
        return structType3;
    }

    public StatsSchemaHelper(StructType structType) {
        this.dataSchema = structType;
        Map<Column, Tuple2<Column, DataType>> map = this.getLogicalToPhysicalColumnAndDataType(structType);
        this.logicalToPhysicalColumn = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Column)((Tuple2)entry.getValue())._1));
        this.logicalToDataType = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (DataType)((Tuple2)entry.getValue())._2));
    }

    public Column getMinColumn(Column column) {
        Preconditions.checkArgument(this.isSkippingEligibleMinMaxColumn(column), String.format("%s is not a valid min column for data schema %s", column, this.dataSchema));
        return this.getStatsColumn(column, MIN);
    }

    public Column getMaxColumn(Column column) {
        Preconditions.checkArgument(this.isSkippingEligibleMinMaxColumn(column), String.format("%s is not a valid min column for data schema %s", column, this.dataSchema));
        return this.getStatsColumn(column, MAX);
    }

    public Column getNullCountColumn(Column column) {
        Preconditions.checkArgument(this.isSkippingEligibleNullCountColumn(column), String.format("%s is not a valid null_count column for data schema %s", column, this.dataSchema));
        return this.getStatsColumn(column, NULL_COUNT);
    }

    public Column getNumRecordsColumn() {
        return new Column(NUM_RECORDS);
    }

    public boolean isSkippingEligibleMinMaxColumn(Column column) {
        return this.logicalToDataType.containsKey(column) && StatsSchemaHelper.isSkippingEligibleDataType(this.logicalToDataType.get(column)) && !(this.logicalToDataType.get(column) instanceof TimestampType);
    }

    public boolean isSkippingEligibleNullCountColumn(Column column) {
        return this.logicalToPhysicalColumn.containsKey(column);
    }

    private static boolean isSkippingEligibleDataType(DataType dataType) {
        return SKIPPING_ELIGIBLE_TYPE_NAMES.contains(dataType.toString()) || dataType instanceof DecimalType;
    }

    private static StructType getMinMaxStatsSchema(StructType structType) {
        ArrayList<StructField> arrayList = new ArrayList<StructField>();
        for (StructField structField : structType.fields()) {
            if (StatsSchemaHelper.isSkippingEligibleDataType(structField.getDataType())) {
                arrayList.add(new StructField(ColumnMapping.getPhysicalName(structField), structField.getDataType(), true));
                continue;
            }
            if (!(structField.getDataType() instanceof StructType)) continue;
            arrayList.add(new StructField(ColumnMapping.getPhysicalName(structField), StatsSchemaHelper.getMinMaxStatsSchema((StructType)structField.getDataType()), true));
        }
        return new StructType(arrayList);
    }

    private static StructType getNullCountSchema(StructType structType) {
        ArrayList<StructField> arrayList = new ArrayList<StructField>();
        for (StructField structField : structType.fields()) {
            if (structField.getDataType() instanceof StructType) {
                arrayList.add(new StructField(ColumnMapping.getPhysicalName(structField), StatsSchemaHelper.getNullCountSchema((StructType)structField.getDataType()), true));
                continue;
            }
            arrayList.add(new StructField(ColumnMapping.getPhysicalName(structField), LongType.LONG, true));
        }
        return new StructType(arrayList);
    }

    private Column getStatsColumn(Column column, String string) {
        Preconditions.checkArgument(this.logicalToPhysicalColumn.containsKey(column), String.format("%s is not a valid leaf column for data schema", column, this.dataSchema));
        return StatsSchemaHelper.getChildColumn(this.logicalToPhysicalColumn.get(column), string);
    }

    private Map<Column, Tuple2<Column, DataType>> getLogicalToPhysicalColumnAndDataType(StructType structType) {
        HashMap<Column, Tuple2<Column, DataType>> hashMap = new HashMap<Column, Tuple2<Column, DataType>>();
        for (StructField structField : structType.fields()) {
            if (structField.getDataType() instanceof StructType) {
                Map<Column, Tuple2<Column, DataType>> map = this.getLogicalToPhysicalColumnAndDataType((StructType)structField.getDataType());
                for (Column column : map.keySet()) {
                    Tuple2<Column, DataType> tuple2 = map.get(column);
                    Column column2 = (Column)tuple2._1;
                    DataType dataType = (DataType)tuple2._2;
                    hashMap.put(StatsSchemaHelper.getChildColumn(column, structField.getName()), new Tuple2<Column, DataType>(StatsSchemaHelper.getChildColumn(column2, ColumnMapping.getPhysicalName(structField)), dataType));
                }
                continue;
            }
            hashMap.put(new Column(structField.getName()), new Tuple2<Column, DataType>(new Column(ColumnMapping.getPhysicalName(structField)), structField.getDataType()));
        }
        return hashMap;
    }

    private static Column getChildColumn(Column column, String string) {
        return new Column(StatsSchemaHelper.prependArray(column.getNames(), string));
    }

    private static String[] prependArray(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }
}

