/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.FieldMetadata;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.util.Map;

public class ColumnMapping {
    public static final String COLUMN_MAPPING_MODE_KEY = "delta.columnMapping.mode";
    public static final String COLUMN_MAPPING_MODE_NONE = "none";
    public static final String COLUMN_MAPPING_MODE_NAME = "name";
    public static final String COLUMN_MAPPING_MODE_ID = "id";
    public static final String COLUMN_MAPPING_PHYSICAL_NAME_KEY = "delta.columnMapping.physicalName";
    public static final String COLUMN_MAPPING_ID_KEY = "delta.columnMapping.id";
    public static final String PARQUET_FIELD_ID_KEY = "parquet.field.id";

    private ColumnMapping() {
    }

    public static String getColumnMappingMode(Map<String, String> map) {
        return map.getOrDefault(COLUMN_MAPPING_MODE_KEY, COLUMN_MAPPING_MODE_NONE);
    }

    public static void throwOnUnsupportedColumnMappingMode(Metadata metadata) {
        String string;
        switch (string = ColumnMapping.getColumnMappingMode(metadata.getConfiguration())) {
            case "none": 
            case "id": 
            case "name": {
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported column mapping mode: " + string);
    }

    public static StructType convertToPhysicalSchema(StructType structType, StructType structType2, String string) {
        switch (string) {
            case "none": {
                return structType;
            }
            case "id": 
            case "name": {
                boolean bl = string.equals(COLUMN_MAPPING_MODE_ID);
                return ColumnMapping.convertToPhysicalSchema(structType, structType2, bl);
            }
        }
        throw new UnsupportedOperationException("Unsupported column mapping mode: " + string);
    }

    private static StructType convertToPhysicalSchema(StructType structType, StructType structType2, boolean bl) {
        StructType structType3 = new StructType();
        for (StructField structField : structType.fields()) {
            DataType dataType = structField.getDataType();
            StructField structField2 = structType2.get(structField.getName());
            DataType dataType2 = ColumnMapping.convertToPhysicalType(dataType, structField2.getDataType(), bl);
            String string = (String)structField2.getMetadata().get(COLUMN_MAPPING_PHYSICAL_NAME_KEY);
            if (bl) {
                Long l = (Long)structField2.getMetadata().get(COLUMN_MAPPING_ID_KEY);
                FieldMetadata fieldMetadata = FieldMetadata.builder().putLong(PARQUET_FIELD_ID_KEY, l).build();
                structType3 = structType3.add(string, dataType2, structField.isNullable(), fieldMetadata);
                continue;
            }
            structType3 = structType3.add(string, dataType2, structField.isNullable());
        }
        return structType3;
    }

    private static DataType convertToPhysicalType(DataType dataType, DataType dataType2, boolean bl) {
        if (dataType instanceof StructType) {
            return ColumnMapping.convertToPhysicalSchema((StructType)dataType, (StructType)dataType2, bl);
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            return new ArrayType(ColumnMapping.convertToPhysicalType(arrayType.getElementType(), ((ArrayType)dataType2).getElementType(), bl), arrayType.containsNull());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            MapType mapType2 = (MapType)dataType2;
            return new MapType(ColumnMapping.convertToPhysicalType(mapType.getKeyType(), mapType2.getKeyType(), bl), ColumnMapping.convertToPhysicalType(mapType.getValueType(), mapType2.getValueType(), bl), mapType.isValueContainsNull());
        }
        return dataType;
    }

    public static String getPhysicalName(StructField structField) {
        if (structField.getMetadata().contains(COLUMN_MAPPING_PHYSICAL_NAME_KEY)) {
            return (String)structField.getMetadata().get(COLUMN_MAPPING_PHYSICAL_NAME_KEY);
        }
        return structField.getName();
    }
}

