/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.internal.fs.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class FileNames {
    private static final Pattern DELTA_FILE_PATTERN = Pattern.compile("\\d+\\.json");
    private static final Pattern CHECKPOINT_FILE_PATTERN = Pattern.compile("(\\d+)\\.checkpoint((\\.\\d+\\.\\d+)?\\.parquet|\\.[^.]+\\.(json|parquet))");
    private static final Pattern CLASSIC_CHECKPOINT_FILE_PATTERN = Pattern.compile("\\d+\\.checkpoint\\.parquet");
    private static final Pattern V2_CHECKPOINT_FILE_PATTERN = Pattern.compile("(\\d+)\\.checkpoint\\.[^.]+\\.(json|parquet)");
    private static final Pattern MULTI_PART_CHECKPOINT_FILE_PATTERN = Pattern.compile("(\\d+)\\.checkpoint\\.\\d+\\.\\d+\\.parquet");
    public static final String SIDECAR_DIRECTORY = "_sidecars";

    private FileNames() {
    }

    public static String deltaFile(Path path, long l) {
        return String.format("%s/%020d.json", path, l);
    }

    public static long deltaVersion(Path path) {
        return Long.parseLong(path.getName().split("\\.")[0]);
    }

    public static long deltaVersion(String string) {
        int n = string.lastIndexOf("/");
        String string2 = string.substring(n + 1);
        return Long.parseLong(string2.split("\\.")[0]);
    }

    public static long checkpointVersion(Path path) {
        return Long.parseLong(path.getName().split("\\.")[0]);
    }

    public static long checkpointVersion(String string) {
        int n = string.lastIndexOf("/");
        String string2 = string.substring(n + 1);
        return Long.parseLong(string2.split("\\.")[0]);
    }

    public static String sidecarFile(Path path, String string) {
        return String.format("%s/%s/%s", path.toString(), SIDECAR_DIRECTORY, string);
    }

    public static String listingPrefix(Path path, long l) {
        return String.format("%s/%020d.", path, l);
    }

    public static Path checkpointFileSingular(Path path, long l) {
        return new Path(path, String.format("%020d.checkpoint.parquet", l));
    }

    public static Path topLevelV2CheckpointFile(Path path, long l, String string, String string2) {
        assert (string2.equals("json") || string2.equals("parquet"));
        return new Path(path, String.format("%020d.checkpoint.%s.%s", l, string, string2));
    }

    public static Path v2CheckpointSidecarFile(Path path, String string) {
        return new Path(String.format("%s/_sidecars/%s.parquet", path.toString(), string));
    }

    public static List<Path> checkpointFileWithParts(Path path, long l, int n) {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (int i = 1; i < n + 1; ++i) {
            arrayList.add(new Path(path, String.format("%020d.checkpoint.%010d.%010d.parquet", l, i, n)));
        }
        return arrayList;
    }

    public static boolean isCheckpointFile(String string) {
        return CHECKPOINT_FILE_PATTERN.matcher(new Path(string).getName()).matches();
    }

    public static boolean isClassicCheckpointFile(String string) {
        return CLASSIC_CHECKPOINT_FILE_PATTERN.matcher(string).matches();
    }

    public static boolean isMulitPartCheckpointFile(String string) {
        return MULTI_PART_CHECKPOINT_FILE_PATTERN.matcher(string).matches();
    }

    public static boolean isV2CheckpointFile(String string) {
        return V2_CHECKPOINT_FILE_PATTERN.matcher(string).matches();
    }

    public static boolean isCommitFile(String string) {
        return DELTA_FILE_PATTERN.matcher(new Path(string).getName()).matches();
    }

    public static long getFileVersion(Path path) {
        if (FileNames.isCheckpointFile(path.getName())) {
            return FileNames.checkpointVersion(path);
        }
        if (FileNames.isCommitFile(path.getName())) {
            return FileNames.deltaVersion(path);
        }
        throw new IllegalArgumentException(String.format("Unexpected file type found in transaction log: %s", path));
    }
}

