/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.Function;

public class DefaultSubFieldVector
implements ColumnVector {
    private final int size;
    private final DataType dataType;
    private final int columnOrdinal;
    private final Function<Integer, Row> rowIdToRowAccessor;

    public DefaultSubFieldVector(int n, DataType dataType, int n2, Function<Integer, Row> function) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (String)"invalid size: %s", (Object[])new Object[]{n});
        this.size = n;
        Preconditions.checkArgument((n2 >= 0 ? 1 : 0) != 0, (String)"invalid column ordinal: %s", (Object[])new Object[]{n2});
        this.columnOrdinal = n2;
        this.rowIdToRowAccessor = Objects.requireNonNull(function, "rowIdToRowAccessor is null");
        this.dataType = Objects.requireNonNull(dataType, "dataType is null");
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getSize() {
        return this.size;
    }

    public void close() {
    }

    public boolean isNullAt(int n) {
        this.assertValidRowId(n);
        Row row = this.rowIdToRowAccessor.apply(n);
        return row == null || row.isNullAt(this.columnOrdinal);
    }

    public boolean getBoolean(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getBoolean(this.columnOrdinal);
    }

    public byte getByte(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getByte(this.columnOrdinal);
    }

    public short getShort(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getShort(this.columnOrdinal);
    }

    public int getInt(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getInt(this.columnOrdinal);
    }

    public long getLong(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getLong(this.columnOrdinal);
    }

    public float getFloat(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getFloat(this.columnOrdinal);
    }

    public double getDouble(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getDouble(this.columnOrdinal);
    }

    public byte[] getBinary(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getBinary(this.columnOrdinal);
    }

    public String getString(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getString(this.columnOrdinal);
    }

    public BigDecimal getDecimal(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getDecimal(this.columnOrdinal);
    }

    public MapValue getMap(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getMap(this.columnOrdinal);
    }

    public ArrayValue getArray(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getArray(this.columnOrdinal);
    }

    public ColumnVector getChild(int n2) {
        StructType structType = (StructType)this.dataType;
        StructField structField = structType.at(n2);
        return new DefaultSubFieldVector(this.size, structField.getDataType(), n2, n -> {
            if (this.isNullAt((int)n)) {
                return null;
            }
            return this.rowIdToRowAccessor.apply((Integer)n).getStruct(this.columnOrdinal);
        });
    }

    private void assertValidRowId(int n) {
        Preconditions.checkArgument((n < this.size ? 1 : 0) != 0, (String)("Invalid rowId: " + n + ", max allowed rowId is: " + (this.size - 1)));
    }
}

