/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FieldMetadata;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

class ParquetSchemaUtils {
    public static final int DECIMAL_MAX_DIGITS_IN_INT = 9;
    public static final int DECIMAL_MAX_DIGITS_IN_LONG = 18;
    public static final List<Integer> MAX_BYTES_PER_PRECISION;

    private ParquetSchemaUtils() {
    }

    static MessageType pruneSchema(GroupType groupType, StructType structType) {
        boolean bl = ParquetSchemaUtils.hasFieldIds((DataType)structType);
        return new MessageType("fileSchema", ParquetSchemaUtils.pruneFields(groupType, structType, bl));
    }

    static Type findSubFieldType(GroupType groupType, StructField structField, Map<Integer, Type> map) {
        int n;
        Object object;
        if (ParquetSchemaUtils.hasFieldId(structField.getMetadata()) && (object = map.get(n = ParquetSchemaUtils.getFieldId(structField.getMetadata()))) != null) {
            return object;
        }
        String string = structField.getName();
        if (groupType.containsField(string)) {
            return groupType.getType(string);
        }
        for (Type type : groupType.getFields()) {
            if (!type.getName().equalsIgnoreCase(string)) continue;
            return type;
        }
        return null;
    }

    static Map<Integer, Type> getParquetFieldToTypeMap(GroupType groupType) {
        return groupType.getFields().stream().filter(type -> type.getId() != null).collect(Collectors.toMap(type -> type.getId().intValue(), type -> type, (type, type2) -> {
            throw new IllegalStateException(String.format("Parquet file contains multiple columns (%s, %s) with the same field id", type, type2));
        }));
    }

    public static MessageType toParquetSchema(StructType structType) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (StructField structField : structType.fields()) {
            arrayList.add(ParquetSchemaUtils.toParquetType(structField.getDataType(), structField.getName(), structField.isNullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED, ParquetSchemaUtils.getFieldId(structField)));
        }
        return new MessageType("Default Kernel Schema", arrayList);
    }

    private static List<Type> pruneFields(GroupType groupType, StructType structType, boolean bl) {
        Map<Integer, Type> map = ParquetSchemaUtils.getParquetFieldToTypeMap(groupType);
        return structType.fields().stream().map(structField -> {
            Type type = ParquetSchemaUtils.findSubFieldType(groupType, structField, map);
            if (type != null) {
                return ParquetSchemaUtils.prunedType(type, structField.getDataType(), bl);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Type prunedType(Type type, DataType dataType, boolean bl) {
        if (type instanceof GroupType && dataType instanceof StructType) {
            GroupType groupType = (GroupType)type;
            StructType structType = (StructType)dataType;
            return groupType.withNewFields(ParquetSchemaUtils.pruneFields(groupType, structType, bl));
        }
        return type;
    }

    private static Type toParquetType(DataType dataType, String string, Type.Repetition repetition, Optional<Integer> optional) {
        Type type;
        if (dataType instanceof BooleanType) {
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(string);
        } else if (dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType) {
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(string);
        } else if (dataType instanceof LongType) {
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(string);
        } else if (dataType instanceof FloatType) {
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(string);
        } else if (dataType instanceof DoubleType) {
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(string);
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            int n = decimalType.getPrecision();
            int n2 = decimalType.getScale();
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation = LogicalTypeAnnotation.decimalType((int)n2, (int)n);
            type = n <= 9 ? (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)decimalLogicalTypeAnnotation)).named(string) : (n <= 18 ? (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)decimalLogicalTypeAnnotation)).named(string) : (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)decimalLogicalTypeAnnotation)).length(MAX_BYTES_PER_PRECISION.get(n).intValue())).named(string));
        } else if (dataType instanceof StringType) {
            type = (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(string);
        } else if (dataType instanceof BinaryType) {
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(string);
        } else if (dataType instanceof DateType) {
            type = (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType())).named(string);
        } else if (dataType instanceof TimestampType) {
            type = (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named(string);
        } else if (dataType instanceof TimestampNTZType) {
            type = (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named(string);
        } else if (dataType instanceof ArrayType) {
            type = ParquetSchemaUtils.toParquetArrayType((ArrayType)dataType, string, repetition);
        } else if (dataType instanceof MapType) {
            type = ParquetSchemaUtils.toParquetMapType((MapType)dataType, string, repetition);
        } else if (dataType instanceof StructType) {
            type = ParquetSchemaUtils.toParquetStructType((StructType)dataType, string, repetition);
        } else {
            throw new UnsupportedOperationException("Writing given type data to Parquet is not supported: " + dataType);
        }
        if (optional.isPresent()) {
            type = type.withId(optional.get().intValue());
        }
        return type;
    }

    private static Type toParquetArrayType(ArrayType arrayType, String string, Type.Repetition repetition) {
        return (Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)((Types.GroupBuilder)Types.repeatedGroup().addField(ParquetSchemaUtils.toParquetType(arrayType.getElementType(), "element", arrayType.containsNull() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED, Optional.empty()))).named("list"))).named(string);
    }

    private static Type toParquetMapType(MapType mapType, String string, Type.Repetition repetition) {
        return (Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType())).addField((Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.repeatedGroup().addField(ParquetSchemaUtils.toParquetType(mapType.getKeyType(), "key", Type.Repetition.REQUIRED, Optional.empty()))).addField(ParquetSchemaUtils.toParquetType(mapType.getValueType(), "value", mapType.isValueContainsNull() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED, Optional.empty()))).named("key_value"))).named(string);
    }

    private static Type toParquetStructType(StructType structType, String string, Type.Repetition repetition) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (StructField structField : structType.fields()) {
            arrayList.add(ParquetSchemaUtils.toParquetType(structField.getDataType(), structField.getName(), structField.isNullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED, ParquetSchemaUtils.getFieldId(structField)));
        }
        return new GroupType(repetition, string, arrayList);
    }

    private static boolean hasFieldIds(DataType dataType) {
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            for (StructField structField : structType.fields()) {
                if (!ParquetSchemaUtils.hasFieldId(structField.getMetadata()) && !ParquetSchemaUtils.hasFieldIds(structField.getDataType())) continue;
                return true;
            }
            return false;
        }
        if (dataType instanceof ArrayType) {
            return ParquetSchemaUtils.hasFieldIds(((ArrayType)dataType).getElementType());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            return ParquetSchemaUtils.hasFieldIds(mapType.getKeyType()) || ParquetSchemaUtils.hasFieldIds(mapType.getValueType());
        }
        return false;
    }

    private static boolean hasFieldId(FieldMetadata fieldMetadata) {
        return fieldMetadata.contains("parquet.field.id");
    }

    private static int getFieldId(FieldMetadata fieldMetadata) {
        Long l = (Long)fieldMetadata.get("parquet.field.id");
        long l2 = l;
        int n = (int)l2;
        Preconditions.checkArgument(((long)n == l2 ? 1 : 0) != 0, (String)"Field id out of range", (Object[])new Object[]{l2});
        return n;
    }

    private static Optional<Integer> getFieldId(StructField structField) {
        if (ParquetSchemaUtils.hasFieldId(structField.getMetadata())) {
            return Optional.of(ParquetSchemaUtils.getFieldId(structField.getMetadata()));
        }
        return Optional.empty();
    }

    static {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i <= 38; ++i) {
            int n = 1;
            while (Math.pow(2.0, 8 * n - 1) < Math.pow(10.0, i)) {
                ++n;
            }
            arrayList.add(n);
        }
        MAX_BYTES_PER_PRECISION = Collections.unmodifiableList(arrayList);
    }
}

