/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone;

import io.delta.standalone.actions.Action;
import io.delta.storage.CloseableIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class VersionLog {
    private final long version;
    @Nonnull
    private final List<Action> actions;

    public VersionLog(long l, @Nonnull List<Action> list) {
        this.version = l;
        this.actions = list;
    }

    public long getVersion() {
        return this.version;
    }

    @Nonnull
    public List<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public CloseableIterator<Action> getActionsIterator() {
        VersionLog versionLog = this;
        synchronized (versionLog) {
            return new CloseableIterator<Action>(){
                private final Iterator<Action> wrap;
                {
                    this.wrap = VersionLog.this.actions.iterator();
                }

                public void close() {
                }

                public boolean hasNext() {
                    return this.wrap.hasNext();
                }

                public Action next() {
                    return this.wrap.next();
                }
            };
        }
    }
}

