/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.util;

import java.net.URI;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class FileNames$ {
    public static FileNames$ MODULE$;
    private final Pattern deltaFilePattern;
    private final Pattern checkpointFilePattern;

    static {
        new FileNames$();
    }

    public Pattern deltaFilePattern() {
        return this.deltaFilePattern;
    }

    public Pattern checkpointFilePattern() {
        return this.checkpointFilePattern;
    }

    public Path deltaFile(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, new StringOps("%020d.json").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public long deltaVersion(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".json"))).toLong();
    }

    public Path checkpointPrefix(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, new StringOps("%020d.checkpoint").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public Path checkpointFileSingular(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, new StringOps("%020d.checkpoint.parquet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public Seq<Path> checkpointFileWithParts(Path path, long version, int numParts) {
        return (Seq)package$.MODULE$.Range().apply(1, numParts + 1).map((Function1 & java.io.Serializable & Serializable)i -> FileNames$.$anonfun$checkpointFileWithParts$1(path, version, numParts, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Option<Object> numCheckpointParts(Path path) {
        String[] segments = path.getName().split("\\.");
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])segments)).size() != 5) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(segments[3])).toInt()));
    }

    public boolean isCheckpointFile(Path path) {
        return this.checkpointFilePattern().matcher(path.getName()).matches();
    }

    public boolean isDeltaFile(Path path) {
        return this.deltaFilePattern().matcher(path.getName()).matches();
    }

    public long checkpointVersion(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0])).toLong();
    }

    public long getFileVersion(Path path) {
        if (this.isCheckpointFile(path)) {
            return this.checkpointVersion(path);
        }
        if (this.isDeltaFile(path)) {
            return this.deltaVersion(path);
        }
        throw new AssertionError((Object)new StringBuilder(47).append("Unexpected file type found in transaction log: ").append(path).toString());
    }

    public Path absolutePath(Path parentDir, String child) {
        Path p = new Path(new URI(child));
        if (p.isAbsolute()) {
            return p;
        }
        return new Path(parentDir, p);
    }

    public static final /* synthetic */ Path $anonfun$checkpointFileWithParts$1(Path path$1, long version$1, int numParts$1, int i) {
        long arg$macro$1 = version$1;
        int arg$macro$2 = i;
        int arg$macro$3 = numParts$1;
        return new Path(path$1, new StringOps("%020d.checkpoint.%010d.%010d.parquet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1), BoxesRunTime.boxToInteger((int)arg$macro$2), BoxesRunTime.boxToInteger((int)arg$macro$3)})));
    }

    private FileNames$() {
        MODULE$ = this;
        this.deltaFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+\\.json")).r().pattern();
        this.checkpointFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+\\.checkpoint(\\.\\d+\\.\\d+)?\\.parquet")).r().pattern();
    }
}

