/*
 * Decompiled with CFR 0.152.
 */
package io.delta.storage.internal;

import com.amazonaws.services.s3.model.ListObjectsV2Request;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.Listing;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.S3ListRequest;
import org.apache.hadoop.fs.store.audit.AuditSpan;

public final class S3LogStoreUtil {
    private static PathFilter ACCEPT_ALL = new PathFilter(){

        public boolean accept(Path path) {
            return true;
        }

        public String toString() {
            return "ACCEPT_ALL";
        }
    };

    private S3LogStoreUtil() {
    }

    private static RemoteIterator<S3AFileStatus> s3ListFrom(S3AFileSystem s3AFileSystem, Path path, Path path2) throws IOException {
        int n = S3AUtils.intOption((Configuration)s3AFileSystem.getConf(), (String)"fs.s3a.paging.maximum", (int)5000, (int)1);
        Listing listing = s3AFileSystem.getListing();
        return listing.createFileStatusListingIterator(path, S3ListRequest.v2((ListObjectsV2Request)new ListObjectsV2Request().withBucketName(s3AFileSystem.getBucket()).withMaxKeys(Integer.valueOf(n)).withPrefix(s3AFileSystem.pathToKey(path2)).withStartAfter(S3LogStoreUtil.keyBefore(s3AFileSystem.pathToKey(path)))), ACCEPT_ALL, (Listing.FileStatusAcceptor)new Listing.AcceptAllButSelfAndS3nDirs(path2), (AuditSpan)s3AFileSystem.getActiveAuditSpan());
    }

    public static FileStatus[] s3ListFromArray(FileSystem fileSystem, Path path, Path path2) throws IOException {
        S3AFileSystem s3AFileSystem;
        try {
            s3AFileSystem = (S3AFileSystem)fileSystem;
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("The Hadoop file system used for the S3LogStore must be castable to org.apache.hadoop.fs.s3a.S3AFileSystem.", classCastException);
        }
        return S3AUtils.iteratorToStatuses(S3LogStoreUtil.s3ListFrom(s3AFileSystem, path, path2), new HashSet());
    }

    static String keyBefore(String string) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        if (byArray.length == 0) {
            return null;
        }
        if (byArray[byArray.length - 1] > 0) {
            int n = byArray.length - 1;
            byArray[n] = (byte)(byArray[n] - 1);
            return new String(byArray, StandardCharsets.UTF_8);
        }
        return new String(byArray, 0, byArray.length - 1, StandardCharsets.UTF_8);
    }
}

