/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ErrorMessage {
    private final int code;
    private final String message;
    @Nullable
    private final String details;

    public ErrorMessage(String message) {
        this(500, message);
    }

    public ErrorMessage(int code, String message) {
        this(code, message, null);
    }

    @JsonCreator
    public ErrorMessage(@JsonProperty(value="code") int code, @JsonProperty(value="message") String message, @Nullable @JsonProperty(value="details") String details) {
        this.code = code;
        this.message = message;
        this.details = details;
    }

    @JsonProperty(value="code")
    public Integer getCode() {
        return this.code;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="details")
    @Nullable
    public String getDetails() {
        return this.details;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorMessage other = (ErrorMessage)obj;
        return Objects.equals(this.code, other.code) && Objects.equals(this.message, other.message) && Objects.equals(this.details, other.details);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message, this.details);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("code", this.code).add("message", (Object)this.message).add("details", (Object)this.details).toString();
    }
}

