/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.request.logging.old;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.AppenderFactory;
import io.dropwizard.logging.ConsoleAppenderFactory;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.async.AsyncLoggingEventAppenderFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.filter.NullLevelFilterFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import io.dropwizard.request.logging.RequestLogFactory;
import io.dropwizard.request.logging.old.ClassicLogFormat;
import io.dropwizard.request.logging.old.DropwizardSlf4jRequestLogWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="classic")
public class LogbackClassicRequestLogFactory
implements RequestLogFactory<RequestLog> {
    @NotNull
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    @Valid
    @NotNull
    private List<AppenderFactory<ILoggingEvent>> appenders = Collections.singletonList(new ConsoleAppenderFactory());

    @JsonProperty
    public List<AppenderFactory<ILoggingEvent>> getAppenders() {
        return this.appenders;
    }

    @JsonProperty
    public void setAppenders(List<AppenderFactory<ILoggingEvent>> appenders) {
        this.appenders = appenders;
    }

    @JsonProperty
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    @JsonIgnore
    public boolean isEnabled() {
        return !this.appenders.isEmpty();
    }

    @Override
    public RequestLog build(String name) {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"http.request");
        logger.setAdditive(false);
        LoggerContext context = logger.getLoggerContext();
        NullLevelFilterFactory levelFilterFactory = new NullLevelFilterFactory();
        AsyncLoggingEventAppenderFactory asyncAppenderFactory = new AsyncLoggingEventAppenderFactory();
        LayoutFactory layoutFactory = (c, tz) -> new RequestLogLayout((Context)c);
        AppenderAttachableImpl attachable = new AppenderAttachableImpl();
        for (AppenderFactory<ILoggingEvent> appender : this.appenders) {
            attachable.addAppender(appender.build(context, name, layoutFactory, (LevelFilterFactory)levelFilterFactory, (AsyncAppenderFactory)asyncAppenderFactory));
        }
        return new CustomRequestLog((RequestLog.Writer)new DropwizardSlf4jRequestLogWriter((AppenderAttachableImpl<ILoggingEvent>)attachable), ClassicLogFormat.pattern(this.timeZone));
    }

    private static class RequestLogLayout
    extends PatternLayoutBase<ILoggingEvent> {
        private RequestLogLayout(Context context) {
            this.setContext(context);
        }

        public String doLayout(ILoggingEvent event) {
            return event.getFormattedMessage() + CoreConstants.LINE_SEPARATOR;
        }

        public Map<String, String> getDefaultConverterMap() {
            return Collections.emptyMap();
        }
    }
}

