/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import io.druid.data.input.InputRow;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.parsers.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public class Rows {
    public static final Long LONG_ZERO = 0L;

    public static List<Object> toGroupKey(long timeStamp, InputRow inputRow) {
        TreeMap dims = Maps.newTreeMap();
        for (String dim : inputRow.getDimensions()) {
            ImmutableSortedSet dimValues = ImmutableSortedSet.copyOf(inputRow.getDimension(dim));
            if (dimValues.size() <= 0) continue;
            dims.put(dim, dimValues);
        }
        return ImmutableList.of((Object)timeStamp, (Object)dims);
    }

    public static List<String> objectToStrings(Object inputValue) {
        if (inputValue == null) {
            return Collections.emptyList();
        }
        if (inputValue instanceof List) {
            List values = (List)inputValue;
            ArrayList<String> retVal = new ArrayList<String>(values.size());
            for (Object val : values) {
                retVal.add(String.valueOf(val));
            }
            return retVal;
        }
        return Collections.singletonList(String.valueOf(inputValue));
    }

    public static Number objectToNumber(String name, Object inputValue) {
        if (inputValue == null) {
            return LONG_ZERO;
        }
        if (inputValue instanceof Number) {
            return (Number)inputValue;
        }
        if (inputValue instanceof String) {
            try {
                String metricValueString = StringUtils.removeChar((String)((String)inputValue).trim(), (char)',');
                metricValueString = Rows.trimLeadingPlusOfLongString(metricValueString);
                Long v = Longs.tryParse((String)metricValueString);
                if (v != null) {
                    return v;
                }
                return Double.valueOf(metricValueString);
            }
            catch (Exception e) {
                throw new ParseException((Throwable)e, "Unable to parse value[%s] for field[%s]", new Object[]{inputValue, name});
            }
        }
        throw new ParseException("Unknown type[%s] for field", new Object[]{inputValue.getClass(), inputValue});
    }

    private static String trimLeadingPlusOfLongString(String metricValueString) {
        char secondChar;
        if (metricValueString.length() > 1 && metricValueString.charAt(0) == '+' && (secondChar = metricValueString.charAt(1)) >= '0' && secondChar <= '9') {
            metricValueString = metricValueString.substring(1);
        }
        return metricValueString;
    }
}

