/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl.prefetch;

import com.google.common.annotations.VisibleForTesting;
import io.druid.data.input.impl.prefetch.FetchedFile;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.logger.Logger;
import java.util.ArrayList;
import java.util.List;

class CacheManager<T> {
    private static final Logger LOG = new Logger(CacheManager.class);
    private final long maxCacheCapacityBytes;
    private final List<FetchedFile<T>> files = new ArrayList<FetchedFile<T>>();
    private long totalCachedBytes;

    CacheManager(long maxCacheCapacityBytes) {
        this.maxCacheCapacityBytes = maxCacheCapacityBytes;
    }

    boolean isEnabled() {
        return this.maxCacheCapacityBytes > 0L;
    }

    boolean cacheable() {
        return this.totalCachedBytes < this.maxCacheCapacityBytes;
    }

    FetchedFile<T> cache(FetchedFile<T> fetchedFile) {
        if (!this.cacheable()) {
            throw new ISE("Cache space is full. totalCachedBytes[%d], maxCacheCapacityBytes[%d]", new Object[]{this.totalCachedBytes, this.maxCacheCapacityBytes});
        }
        FetchedFile<T> cachedFile = fetchedFile.cache();
        this.files.add(cachedFile);
        this.totalCachedBytes += cachedFile.length();
        LOG.info("Object[%s] is cached. Current cached bytes is [%d]", new Object[]{cachedFile.getObject(), this.totalCachedBytes});
        return cachedFile;
    }

    List<FetchedFile<T>> getFiles() {
        return this.files;
    }

    @VisibleForTesting
    long getTotalCachedBytes() {
        return this.totalCachedBytes;
    }

    long getMaxCacheCapacityBytes() {
        return this.maxCacheCapacityBytes;
    }
}

