/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl.prefetch;

import io.druid.data.input.impl.prefetch.FetchedFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

class OpenedObject<T> {
    private final T object;
    private final InputStream objectStream;
    private final Closeable resourceCloser;

    OpenedObject(FetchedFile<T> fetchedFile) throws IOException {
        this(fetchedFile.getObject(), FileUtils.openInputStream((File)fetchedFile.getFile()), fetchedFile.getResourceCloser());
    }

    OpenedObject(T object, InputStream objectStream, Closeable resourceCloser) {
        this.object = object;
        this.objectStream = objectStream;
        this.resourceCloser = resourceCloser;
    }

    T getObject() {
        return this.object;
    }

    InputStream getObjectStream() {
        return this.objectStream;
    }

    Closeable getResourceCloser() {
        return this.resourceCloser;
    }
}

