/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.common.base.Predicate;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import java.lang.annotation.Annotation;
import java.util.Properties;

public class ConditionalMultibind<T> {
    private final Properties properties;
    private final Multibinder<T> multibinder;

    public static <T> ConditionalMultibind<T> create(Properties properties, Binder binder, Class<T> type) {
        return new ConditionalMultibind<T>(properties, Multibinder.newSetBinder((Binder)binder, type));
    }

    public static <T> ConditionalMultibind<T> create(Properties properties, Binder binder, Class<T> type, Class<? extends Annotation> annotationType) {
        return new ConditionalMultibind<T>(properties, Multibinder.newSetBinder((Binder)binder, type, annotationType));
    }

    public static <T> ConditionalMultibind<T> create(Properties properties, Binder binder, TypeLiteral<T> type) {
        return new ConditionalMultibind<T>(properties, Multibinder.newSetBinder((Binder)binder, type));
    }

    public static <T> ConditionalMultibind<T> create(Properties properties, Binder binder, TypeLiteral<T> type, Class<? extends Annotation> annotationType) {
        return new ConditionalMultibind<T>(properties, Multibinder.newSetBinder((Binder)binder, type, annotationType));
    }

    public ConditionalMultibind(Properties properties, Multibinder<T> multibinder) {
        this.properties = properties;
        this.multibinder = multibinder;
    }

    public ConditionalMultibind<T> addBinding(Class<? extends T> target) {
        this.multibinder.addBinding().to(target);
        return this;
    }

    public ConditionalMultibind<T> addBinding(T target) {
        this.multibinder.addBinding().toInstance(target);
        return this;
    }

    public ConditionalMultibind<T> addBinding(TypeLiteral<T> target) {
        this.multibinder.addBinding().to(target);
        return this;
    }

    public ConditionalMultibind<T> addConditionBinding(String property, Predicate<String> condition, Class<? extends T> target) {
        String value = this.properties.getProperty(property);
        if (value == null) {
            return this;
        }
        if (condition.apply((Object)value)) {
            this.multibinder.addBinding().to(target);
        }
        return this;
    }

    public ConditionalMultibind<T> addConditionBinding(String property, Predicate<String> condition, T target) {
        String value = this.properties.getProperty(property);
        if (value == null) {
            return this;
        }
        if (condition.apply((Object)value)) {
            this.multibinder.addBinding().toInstance(target);
        }
        return this;
    }

    public ConditionalMultibind<T> addConditionBinding(String property, Predicate<String> condition, TypeLiteral<T> target) {
        String value = this.properties.getProperty(property);
        if (value == null) {
            return this;
        }
        if (condition.apply((Object)value)) {
            this.multibinder.addBinding().to(target);
        }
        return this;
    }
}

