/*
 * Decompiled with CFR 0.152.
 */
package io.druid.timeline;

import com.google.common.base.Function;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.logger.Logger;
import io.druid.timeline.DataSegment;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class DataSegmentUtils {
    private static final Logger LOGGER = new Logger(DataSegmentUtils.class);

    public static Function<String, Interval> INTERVAL_EXTRACTOR(final String datasource) {
        return new Function<String, Interval>(){

            public Interval apply(String identifier) {
                SegmentIdentifierParts segmentIdentifierParts = DataSegmentUtils.valueOf(datasource, identifier);
                if (segmentIdentifierParts == null) {
                    throw new IAE("Invalid identifier [%s]", new Object[]{identifier});
                }
                return segmentIdentifierParts.getInterval();
            }
        };
    }

    public static SegmentIdentifierParts valueOf(String dataSource, String identifier) {
        if (!identifier.startsWith(StringUtils.format((String)"%s_", (Object[])new Object[]{dataSource}))) {
            return null;
        }
        String remaining = identifier.substring(dataSource.length() + 1);
        Object[] splits = remaining.split(DataSegment.delimiter);
        if (splits.length < 3) {
            return null;
        }
        try {
            DateTime start = DateTimes.ISO_DATE_TIME.parse(splits[0]);
            DateTime end = DateTimes.ISO_DATE_TIME.parse(splits[1]);
            String version = splits[2];
            String trail = splits.length > 3 ? DataSegmentUtils.join(splits, DataSegment.delimiter, 3, splits.length) : null;
            return new SegmentIdentifierParts(dataSource, new Interval((ReadableInstant)start, (ReadableInstant)end), version, trail);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String withInterval(String dataSource, String identifier, Interval newInterval) {
        SegmentIdentifierParts segmentDesc = DataSegmentUtils.valueOf(dataSource, identifier);
        if (segmentDesc == null) {
            LOGGER.warn("Invalid segment identifier " + identifier, new Object[0]);
            return identifier;
        }
        return segmentDesc.withInterval(newInterval).toString();
    }

    private static String join(Object[] input, String delimiter, int start, int end) {
        StringBuilder builder = new StringBuilder();
        for (int i = start; i < end; ++i) {
            if (i > start) {
                builder.append(delimiter);
            }
            if (input[i] == null) continue;
            builder.append(input[i]);
        }
        return builder.toString();
    }

    public static class SegmentIdentifierParts {
        private final String dataSource;
        private final Interval interval;
        private final String version;
        private final String trail;

        public SegmentIdentifierParts(String dataSource, Interval interval, String version, String trail) {
            this.dataSource = dataSource;
            this.interval = interval;
            this.version = version;
            this.trail = trail;
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public String getVersion() {
            return this.version;
        }

        public SegmentIdentifierParts withInterval(Interval interval) {
            return new SegmentIdentifierParts(this.dataSource, interval, this.version, this.trail);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SegmentIdentifierParts that = (SegmentIdentifierParts)o;
            if (!Objects.equals(this.dataSource, that.dataSource)) {
                return false;
            }
            if (!Objects.equals(this.interval, that.interval)) {
                return false;
            }
            if (!Objects.equals(this.version, that.version)) {
                return false;
            }
            return Objects.equals(this.trail, that.trail);
        }

        public int hashCode() {
            return Objects.hash(this.dataSource, this.interval, this.version, this.trail);
        }

        public String toString() {
            return DataSegmentUtils.join(new Object[]{this.dataSource, this.interval.getStart(), this.interval.getEnd(), this.version, this.trail}, DataSegment.delimiter, 0, this.version == null ? 3 : (this.trail == null ? 4 : 5));
        }
    }
}

