/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Supplier;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.util.Types;
import io.druid.common.config.JacksonConfigManager;
import io.druid.common.guava.DSuppliers;
import io.druid.guice.LazySingleton;
import java.lang.reflect.Type;

public class JacksonConfigProvider<T>
implements Provider<Supplier<T>> {
    private final String key;
    private final Class<T> clazz;
    private final TypeReference<T> typeRef;
    private final T defaultVal;
    private JacksonConfigManager configManager;

    public static <T> void bind(Binder binder, String key, Class<T> clazz, T defaultVal) {
        binder.bind(Key.get((Type)Types.newParameterizedType(Supplier.class, (Type[])new Type[]{clazz}))).toProvider(JacksonConfigProvider.of(key, clazz, defaultVal)).in(LazySingleton.class);
    }

    public static <T> JacksonConfigProvider<T> of(String key, Class<T> clazz, T defaultVal) {
        return new JacksonConfigProvider<T>(key, clazz, null, defaultVal);
    }

    JacksonConfigProvider(String key, Class<T> clazz, TypeReference<T> typeRef, T defaultVal) {
        this.key = key;
        this.clazz = clazz;
        this.typeRef = typeRef;
        this.defaultVal = defaultVal;
    }

    @Inject
    public void configure(JacksonConfigManager configManager) {
        this.configManager = configManager;
    }

    public Supplier<T> get() {
        if (this.clazz == null) {
            return DSuppliers.of(this.configManager.watch(this.key, this.typeRef, this.defaultVal));
        }
        return DSuppliers.of(this.configManager.watch(this.key, this.clazz, this.defaultVal));
    }
}

